
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Baseline"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Alternate" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="testStatistic" use="required" type="{http://www.dmg.org/PMML-4_2}BASELINE-TEST-STATISTIC" />
 *       &lt;attribute name="resetValue" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0.0" />
 *       &lt;attribute name="windowSize" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" default="0" />
 *       &lt;attribute name="weightField" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="normalizationScheme" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "baseline",
    "alternate",
    "extensions"
})
@XmlRootElement(name = "TestDistributions", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_1)
public class TestDistributions
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Baseline", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected Baseline baseline;
    @XmlElement(name = "Alternate", namespace = "http://www.dmg.org/PMML-4_2")
    protected Alternate alternate;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    protected FieldName field;
    @XmlAttribute(name = "testStatistic", required = true)
    protected BaselineTestStatisticType testStatistic;
    @XmlAttribute(name = "resetValue")
    protected Double resetValue;
    @XmlAttribute(name = "windowSize")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer windowSize;
    @XmlAttribute(name = "weightField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    protected FieldName weightField;
    @XmlAttribute(name = "normalizationScheme")
    protected String normalizationScheme;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public TestDistributions() {
        super();
    }

    public TestDistributions(final Baseline baseline, final FieldName field, final BaselineTestStatisticType testStatistic) {
        super();
        this.baseline = baseline;
        this.field = field;
        this.testStatistic = testStatistic;
    }

    /**
     * Gets the value of the baseline property.
     * 
     * @return
     *     possible object is
     *     {@link Baseline }
     *     
     */
    public Baseline getBaseline() {
        return baseline;
    }

    /**
     * Sets the value of the baseline property.
     * 
     * @param value
     *     allowed object is
     *     {@link Baseline }
     *     
     */
    public void setBaseline(Baseline value) {
        this.baseline = value;
    }

    /**
     * Gets the value of the alternate property.
     * 
     * @return
     *     possible object is
     *     {@link Alternate }
     *     
     */
    public Alternate getAlternate() {
        return alternate;
    }

    /**
     * Sets the value of the alternate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Alternate }
     *     
     */
    public void setAlternate(Alternate value) {
        this.alternate = value;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setField(FieldName value) {
        this.field = value;
    }

    /**
     * Gets the value of the testStatistic property.
     * 
     * @return
     *     possible object is
     *     {@link BaselineTestStatisticType }
     *     
     */
    public BaselineTestStatisticType getTestStatistic() {
        return testStatistic;
    }

    /**
     * Sets the value of the testStatistic property.
     * 
     * @param value
     *     allowed object is
     *     {@link BaselineTestStatisticType }
     *     
     */
    public void setTestStatistic(BaselineTestStatisticType value) {
        this.testStatistic = value;
    }

    /**
     * Gets the value of the resetValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getResetValue() {
        if (resetValue == null) {
            return  0.0D;
        } else {
            return resetValue;
        }
    }

    /**
     * Sets the value of the resetValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setResetValue(Double value) {
        this.resetValue = value;
    }

    /**
     * Gets the value of the windowSize property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public int getWindowSize() {
        if (windowSize == null) {
            return new IntegerAdapter().unmarshal("0");
        } else {
            return windowSize;
        }
    }

    /**
     * Sets the value of the windowSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setWindowSize(Integer value) {
        this.windowSize = value;
    }

    /**
     * Gets the value of the weightField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getWeightField() {
        return weightField;
    }

    /**
     * Sets the value of the weightField property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setWeightField(FieldName value) {
        this.weightField = value;
    }

    /**
     * Gets the value of the normalizationScheme property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNormalizationScheme() {
        return normalizationScheme;
    }

    /**
     * Sets the value of the normalizationScheme property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNormalizationScheme(String value) {
        this.normalizationScheme = value;
    }

    public TestDistributions withBaseline(Baseline value) {
        setBaseline(value);
        return this;
    }

    public TestDistributions withAlternate(Alternate value) {
        setAlternate(value);
        return this;
    }

    public TestDistributions withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public TestDistributions withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public TestDistributions withField(FieldName value) {
        setField(value);
        return this;
    }

    public TestDistributions withTestStatistic(BaselineTestStatisticType value) {
        setTestStatistic(value);
        return this;
    }

    public TestDistributions withResetValue(Double value) {
        setResetValue(value);
        return this;
    }

    public TestDistributions withWindowSize(Integer value) {
        setWindowSize(value);
        return this;
    }

    public TestDistributions withWeightField(FieldName value) {
        setWeightField(value);
        return this;
    }

    public TestDistributions withNormalizationScheme(String value) {
        setNormalizationScheme(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&(this.baseline!= null)) {
            status = this.baseline.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.alternate!= null)) {
            status = this.alternate.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
