
package org.jpmml.model;

import java.util.ArrayDeque;
import java.util.Deque;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Alternate;
import org.dmg.pmml.Annotation;
import org.dmg.pmml.Anova;
import org.dmg.pmml.AnovaRow;
import org.dmg.pmml.AntecedentSequence;
import org.dmg.pmml.AnyDistribution;
import org.dmg.pmml.Application;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.Attribute;
import org.dmg.pmml.BaseCumHazardTables;
import org.dmg.pmml.Baseline;
import org.dmg.pmml.BaselineCell;
import org.dmg.pmml.BaselineModel;
import org.dmg.pmml.BaselineStratum;
import org.dmg.pmml.BayesInput;
import org.dmg.pmml.BayesInputs;
import org.dmg.pmml.BayesOutput;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.BoundaryValueMeans;
import org.dmg.pmml.BoundaryValues;
import org.dmg.pmml.CategoricalPredictor;
import org.dmg.pmml.Categories;
import org.dmg.pmml.Category;
import org.dmg.pmml.CenterFields;
import org.dmg.pmml.Characteristic;
import org.dmg.pmml.Characteristics;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.ChildParent;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.ClassLabels;
import org.dmg.pmml.Cluster;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.ClusteringModelQuality;
import org.dmg.pmml.Coefficient;
import org.dmg.pmml.Coefficients;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Comparisons;
import org.dmg.pmml.ComplexPartialScore;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.CompoundRule;
import org.dmg.pmml.ConfusionMatrix;
import org.dmg.pmml.Connection;
import org.dmg.pmml.ConsequentSequence;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Constraints;
import org.dmg.pmml.ContStats;
import org.dmg.pmml.CorrelationFields;
import org.dmg.pmml.CorrelationMethods;
import org.dmg.pmml.CorrelationValues;
import org.dmg.pmml.Correlations;
import org.dmg.pmml.CountTable;
import org.dmg.pmml.Counts;
import org.dmg.pmml.Covariances;
import org.dmg.pmml.CovariateList;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Decision;
import org.dmg.pmml.DecisionTree;
import org.dmg.pmml.Decisions;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Delimiter;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.DiscrStats;
import org.dmg.pmml.DiscreteDistribution;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.DocumentTermMatrix;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.EventValues;
import org.dmg.pmml.ExponentialSmoothing;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FactorList;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.FieldValue;
import org.dmg.pmml.FieldValueCount;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.GeneralRegressionModel;
import org.dmg.pmml.Header;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.InstanceField;
import org.dmg.pmml.InstanceFields;
import org.dmg.pmml.IntSparseArray;
import org.dmg.pmml.Interval;
import org.dmg.pmml.Item;
import org.dmg.pmml.ItemRef;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.KNNInput;
import org.dmg.pmml.KNNInputs;
import org.dmg.pmml.KohonenMap;
import org.dmg.pmml.Level;
import org.dmg.pmml.LiftData;
import org.dmg.pmml.LiftGraph;
import org.dmg.pmml.LinearKernelType;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.MatCell;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.MissingValueWeights;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelLiftGraph;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.MultivariateStat;
import org.dmg.pmml.MultivariateStats;
import org.dmg.pmml.NaiveBayesModel;
import org.dmg.pmml.NearestNeighborModel;
import org.dmg.pmml.NeuralInput;
import org.dmg.pmml.NeuralInputs;
import org.dmg.pmml.NeuralLayer;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.NeuralOutput;
import org.dmg.pmml.NeuralOutputs;
import org.dmg.pmml.Neuron;
import org.dmg.pmml.Node;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.NumericInfo;
import org.dmg.pmml.NumericPredictor;
import org.dmg.pmml.OptimumLiftGraph;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PCell;
import org.dmg.pmml.PCovCell;
import org.dmg.pmml.PCovMatrix;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PPCell;
import org.dmg.pmml.PPMatrix;
import org.dmg.pmml.PairCounts;
import org.dmg.pmml.ParamMatrix;
import org.dmg.pmml.Parameter;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.ParameterList;
import org.dmg.pmml.Partition;
import org.dmg.pmml.PartitionFieldStats;
import org.dmg.pmml.PoissonDistribution;
import org.dmg.pmml.PolynomialKernelType;
import org.dmg.pmml.PredictiveModelQuality;
import org.dmg.pmml.Predictor;
import org.dmg.pmml.PredictorTerm;
import org.dmg.pmml.Quantile;
import org.dmg.pmml.ROC;
import org.dmg.pmml.ROCGraph;
import org.dmg.pmml.RadialBasisKernelType;
import org.dmg.pmml.RandomLiftGraph;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.Regression;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RegressionTable;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.Row;
import org.dmg.pmml.RuleSelectionMethod;
import org.dmg.pmml.RuleSet;
import org.dmg.pmml.RuleSetModel;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Scorecard;
import org.dmg.pmml.SeasonalityExpoSmooth;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.dmg.pmml.Sequence;
import org.dmg.pmml.SequenceModel;
import org.dmg.pmml.SequenceReference;
import org.dmg.pmml.SequenceRule;
import org.dmg.pmml.SetPredicate;
import org.dmg.pmml.SetReference;
import org.dmg.pmml.SigmoidKernelType;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleRule;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.SupportVector;
import org.dmg.pmml.SupportVectorMachine;
import org.dmg.pmml.SupportVectorMachineModel;
import org.dmg.pmml.SupportVectors;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.Tanimoto;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.TargetValueCount;
import org.dmg.pmml.TargetValueCounts;
import org.dmg.pmml.TargetValueStat;
import org.dmg.pmml.TargetValueStats;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Taxonomy;
import org.dmg.pmml.TestDistributions;
import org.dmg.pmml.TextCorpus;
import org.dmg.pmml.TextDictionary;
import org.dmg.pmml.TextDocument;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.TextModel;
import org.dmg.pmml.TextModelNormalization;
import org.dmg.pmml.TextModelSimiliarity;
import org.dmg.pmml.Time;
import org.dmg.pmml.TimeAnchor;
import org.dmg.pmml.TimeCycle;
import org.dmg.pmml.TimeException;
import org.dmg.pmml.TimeSeries;
import org.dmg.pmml.TimeSeriesModel;
import org.dmg.pmml.TimeValue;
import org.dmg.pmml.Timestamp;
import org.dmg.pmml.TrainingInstances;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.TrendExpoSmooth;
import org.dmg.pmml.True;
import org.dmg.pmml.UniformDistribution;
import org.dmg.pmml.UnivariateStats;
import org.dmg.pmml.Value;
import org.dmg.pmml.VectorDictionary;
import org.dmg.pmml.VectorFields;
import org.dmg.pmml.VectorInstance;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.XCoordinates;
import org.dmg.pmml.YCoordinates;

public abstract class AbstractSimpleVisitor
    implements Visitor
{

    private Deque<org.dmg.pmml.PMMLObject> parents = new ArrayDeque<org.dmg.pmml.PMMLObject>();

    @Override
    public void pushParent(org.dmg.pmml.PMMLObject parent) {
        parents.addFirst(parent);
    }

    @Override
    public void popParent() {
        parents.removeFirst();
    }

    public Deque<org.dmg.pmml.PMMLObject> getParents() {
        return parents;
    }

    public VisitorAction visit(org.dmg.pmml.PMMLObject object) {
        return VisitorAction.CONTINUE;
    }

    @Override
    public VisitorAction visit(SimplePredicate simplePredicate) {
        return visit(((org.dmg.pmml.Predicate) simplePredicate));
    }

    @Override
    public VisitorAction visit(Array array) {
        return visit(((org.dmg.pmml.PMMLObject) array));
    }

    @Override
    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        return visit(((org.dmg.pmml.Predicate) simpleSetPredicate));
    }

    @Override
    public VisitorAction visit(CompoundPredicate compoundPredicate) {
        return visit(((org.dmg.pmml.Predicate) compoundPredicate));
    }

    @Override
    public VisitorAction visit(NormDiscrete normDiscrete) {
        return visit(((org.dmg.pmml.Expression) normDiscrete));
    }

    @Override
    public VisitorAction visit(Interval interval) {
        return visit(((org.dmg.pmml.PMMLObject) interval));
    }

    @Override
    public VisitorAction visit(Aggregate aggregate) {
        return visit(((org.dmg.pmml.Expression) aggregate));
    }

    @Override
    public VisitorAction visit(TextModelSimiliarity textModelSimiliarity) {
        return visit(((org.dmg.pmml.PMMLObject) textModelSimiliarity));
    }

    @Override
    public VisitorAction visit(Matrix matrix) {
        return visit(((org.dmg.pmml.PMMLObject) matrix));
    }

    @Override
    public VisitorAction visit(OutputField outputField) {
        return visit(((org.dmg.pmml.Field) outputField));
    }

    @Override
    public VisitorAction visit(UnivariateStats univariateStats) {
        return visit(((org.dmg.pmml.PMMLObject) univariateStats));
    }

    @Override
    public VisitorAction visit(Value value) {
        return visit(((org.dmg.pmml.PMMLObject) value));
    }

    @Override
    public VisitorAction visit(ComparisonMeasure comparisonMeasure) {
        return visit(((org.dmg.pmml.PMMLObject) comparisonMeasure));
    }

    @Override
    public VisitorAction visit(ClusteringField clusteringField) {
        return visit(((org.dmg.pmml.ComparisonField) clusteringField));
    }

    @Override
    public VisitorAction visit(PartitionFieldStats partitionFieldStats) {
        return visit(((org.dmg.pmml.PMMLObject) partitionFieldStats));
    }

    @Override
    public VisitorAction visit(ClusteringModel clusteringModel) {
        return visit(((org.dmg.pmml.Model) clusteringModel));
    }

    @Override
    public VisitorAction visit(Target target) {
        return visit(((org.dmg.pmml.PMMLObject) target));
    }

    @Override
    public VisitorAction visit(RuleSelectionMethod ruleSelectionMethod) {
        return visit(((org.dmg.pmml.PMMLObject) ruleSelectionMethod));
    }

    @Override
    public VisitorAction visit(DecisionTree decisionTree) {
        return visit(((org.dmg.pmml.EmbeddedModel) decisionTree));
    }

    @Override
    public VisitorAction visit(PCovMatrix pCovMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) pCovMatrix));
    }

    @Override
    public VisitorAction visit(GeneralRegressionModel generalRegressionModel) {
        return visit(((org.dmg.pmml.Model) generalRegressionModel));
    }

    @Override
    public VisitorAction visit(RegressionModel regressionModel) {
        return visit(((org.dmg.pmml.Model) regressionModel));
    }

    @Override
    public VisitorAction visit(Scorecard scorecard) {
        return visit(((org.dmg.pmml.Model) scorecard));
    }

    @Override
    public VisitorAction visit(ChildParent childParent) {
        return visit(((org.dmg.pmml.PMMLObject) childParent));
    }

    @Override
    public VisitorAction visit(TextModelNormalization textModelNormalization) {
        return visit(((org.dmg.pmml.PMMLObject) textModelNormalization));
    }

    @Override
    public VisitorAction visit(TrendExpoSmooth trendExpoSmooth) {
        return visit(((org.dmg.pmml.PMMLObject) trendExpoSmooth));
    }

    @Override
    public VisitorAction visit(TreeModel treeModel) {
        return visit(((org.dmg.pmml.Model) treeModel));
    }

    @Override
    public VisitorAction visit(DataField dataField) {
        return visit(((org.dmg.pmml.TypeDefinitionField) dataField));
    }

    @Override
    public VisitorAction visit(Characteristic characteristic) {
        return visit(((org.dmg.pmml.PMMLObject) characteristic));
    }

    @Override
    public VisitorAction visit(Extension extension) {
        return visit(((org.dmg.pmml.PMMLObject) extension));
    }

    @Override
    public VisitorAction visit(Attribute attribute) {
        return visit(((org.dmg.pmml.PMMLObject) attribute));
    }

    @Override
    public VisitorAction visit(True _true) {
        return visit(((org.dmg.pmml.Predicate) _true));
    }

    @Override
    public VisitorAction visit(False _false) {
        return visit(((org.dmg.pmml.Predicate) _false));
    }

    @Override
    public VisitorAction visit(ComplexPartialScore complexPartialScore) {
        return visit(((org.dmg.pmml.PMMLObject) complexPartialScore));
    }

    @Override
    public VisitorAction visit(Constant constant) {
        return visit(((org.dmg.pmml.Expression) constant));
    }

    @Override
    public VisitorAction visit(FieldRef fieldRef) {
        return visit(((org.dmg.pmml.Expression) fieldRef));
    }

    @Override
    public VisitorAction visit(NormContinuous normContinuous) {
        return visit(((org.dmg.pmml.Expression) normContinuous));
    }

    @Override
    public VisitorAction visit(LinearNorm linearNorm) {
        return visit(((org.dmg.pmml.PMMLObject) linearNorm));
    }

    @Override
    public VisitorAction visit(Discretize discretize) {
        return visit(((org.dmg.pmml.Expression) discretize));
    }

    @Override
    public VisitorAction visit(DiscretizeBin discretizeBin) {
        return visit(((org.dmg.pmml.PMMLObject) discretizeBin));
    }

    @Override
    public VisitorAction visit(MapValues mapValues) {
        return visit(((org.dmg.pmml.Expression) mapValues));
    }

    @Override
    public VisitorAction visit(FieldColumnPair fieldColumnPair) {
        return visit(((org.dmg.pmml.PMMLObject) fieldColumnPair));
    }

    @Override
    public VisitorAction visit(TableLocator tableLocator) {
        return visit(((org.dmg.pmml.PMMLObject) tableLocator));
    }

    @Override
    public VisitorAction visit(InlineTable inlineTable) {
        return visit(((org.dmg.pmml.PMMLObject) inlineTable));
    }

    @Override
    public VisitorAction visit(Row row) {
        return visit(((org.dmg.pmml.PMMLObject) row));
    }

    @Override
    public VisitorAction visit(TextIndex textIndex) {
        return visit(((org.dmg.pmml.Expression) textIndex));
    }

    @Override
    public VisitorAction visit(TextIndexNormalization textIndexNormalization) {
        return visit(((org.dmg.pmml.PMMLObject) textIndexNormalization));
    }

    @Override
    public VisitorAction visit(Apply apply) {
        return visit(((org.dmg.pmml.Expression) apply));
    }

    @Override
    public VisitorAction visit(MiningSchema miningSchema) {
        return visit(((org.dmg.pmml.PMMLObject) miningSchema));
    }

    @Override
    public VisitorAction visit(MiningField miningField) {
        return visit(((org.dmg.pmml.Field) miningField));
    }

    @Override
    public VisitorAction visit(TimeCycle timeCycle) {
        return visit(((org.dmg.pmml.PMMLObject) timeCycle));
    }

    @Override
    public VisitorAction visit(Characteristics characteristics) {
        return visit(((org.dmg.pmml.PMMLObject) characteristics));
    }

    @Override
    public VisitorAction visit(MatCell matCell) {
        return visit(((org.dmg.pmml.PMMLObject) matCell));
    }

    @Override
    public VisitorAction visit(PCell pCell) {
        return visit(((org.dmg.pmml.ParameterCell) pCell));
    }

    @Override
    public VisitorAction visit(ItemRef itemRef) {
        return visit(((org.dmg.pmml.PMMLObject) itemRef));
    }

    @Override
    public VisitorAction visit(LiftGraph liftGraph) {
        return visit(((org.dmg.pmml.PMMLObject) liftGraph));
    }

    @Override
    public VisitorAction visit(XCoordinates xCoordinates) {
        return visit(((org.dmg.pmml.PMMLObject) xCoordinates));
    }

    @Override
    public VisitorAction visit(YCoordinates yCoordinates) {
        return visit(((org.dmg.pmml.PMMLObject) yCoordinates));
    }

    @Override
    public VisitorAction visit(BoundaryValues boundaryValues) {
        return visit(((org.dmg.pmml.PMMLObject) boundaryValues));
    }

    @Override
    public VisitorAction visit(BoundaryValueMeans boundaryValueMeans) {
        return visit(((org.dmg.pmml.PMMLObject) boundaryValueMeans));
    }

    @Override
    public VisitorAction visit(Output output) {
        return visit(((org.dmg.pmml.PMMLObject) output));
    }

    @Override
    public VisitorAction visit(Decisions decisions) {
        return visit(((org.dmg.pmml.PMMLObject) decisions));
    }

    @Override
    public VisitorAction visit(Decision decision) {
        return visit(((org.dmg.pmml.PMMLObject) decision));
    }

    @Override
    public VisitorAction visit(ModelStats modelStats) {
        return visit(((org.dmg.pmml.PMMLObject) modelStats));
    }

    @Override
    public VisitorAction visit(Counts counts) {
        return visit(((org.dmg.pmml.PMMLObject) counts));
    }

    @Override
    public VisitorAction visit(NumericInfo numericInfo) {
        return visit(((org.dmg.pmml.PMMLObject) numericInfo));
    }

    @Override
    public VisitorAction visit(Quantile quantile) {
        return visit(((org.dmg.pmml.PMMLObject) quantile));
    }

    @Override
    public VisitorAction visit(DiscrStats discrStats) {
        return visit(((org.dmg.pmml.PMMLObject) discrStats));
    }

    @Override
    public VisitorAction visit(ContStats contStats) {
        return visit(((org.dmg.pmml.PMMLObject) contStats));
    }

    @Override
    public VisitorAction visit(Anova anova) {
        return visit(((org.dmg.pmml.PMMLObject) anova));
    }

    @Override
    public VisitorAction visit(AnovaRow anovaRow) {
        return visit(((org.dmg.pmml.PMMLObject) anovaRow));
    }

    @Override
    public VisitorAction visit(MultivariateStats multivariateStats) {
        return visit(((org.dmg.pmml.PMMLObject) multivariateStats));
    }

    @Override
    public VisitorAction visit(MultivariateStat multivariateStat) {
        return visit(((org.dmg.pmml.PMMLObject) multivariateStat));
    }

    @Override
    public VisitorAction visit(ModelExplanation modelExplanation) {
        return visit(((org.dmg.pmml.PMMLObject) modelExplanation));
    }

    @Override
    public VisitorAction visit(PredictiveModelQuality predictiveModelQuality) {
        return visit(((org.dmg.pmml.PMMLObject) predictiveModelQuality));
    }

    @Override
    public VisitorAction visit(ConfusionMatrix confusionMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) confusionMatrix));
    }

    @Override
    public VisitorAction visit(ClassLabels classLabels) {
        return visit(((org.dmg.pmml.PMMLObject) classLabels));
    }

    @Override
    public VisitorAction visit(LiftData liftData) {
        return visit(((org.dmg.pmml.PMMLObject) liftData));
    }

    @Override
    public VisitorAction visit(ModelLiftGraph modelLiftGraph) {
        return visit(((org.dmg.pmml.PMMLObject) modelLiftGraph));
    }

    @Override
    public VisitorAction visit(OptimumLiftGraph optimumLiftGraph) {
        return visit(((org.dmg.pmml.PMMLObject) optimumLiftGraph));
    }

    @Override
    public VisitorAction visit(RandomLiftGraph randomLiftGraph) {
        return visit(((org.dmg.pmml.PMMLObject) randomLiftGraph));
    }

    @Override
    public VisitorAction visit(ROC roc) {
        return visit(((org.dmg.pmml.PMMLObject) roc));
    }

    @Override
    public VisitorAction visit(ROCGraph rocGraph) {
        return visit(((org.dmg.pmml.PMMLObject) rocGraph));
    }

    @Override
    public VisitorAction visit(ClusteringModelQuality clusteringModelQuality) {
        return visit(((org.dmg.pmml.PMMLObject) clusteringModelQuality));
    }

    @Override
    public VisitorAction visit(Correlations correlations) {
        return visit(((org.dmg.pmml.PMMLObject) correlations));
    }

    @Override
    public VisitorAction visit(CorrelationFields correlationFields) {
        return visit(((org.dmg.pmml.PMMLObject) correlationFields));
    }

    @Override
    public VisitorAction visit(CorrelationValues correlationValues) {
        return visit(((org.dmg.pmml.PMMLObject) correlationValues));
    }

    @Override
    public VisitorAction visit(CorrelationMethods correlationMethods) {
        return visit(((org.dmg.pmml.PMMLObject) correlationMethods));
    }

    @Override
    public VisitorAction visit(LocalTransformations localTransformations) {
        return visit(((org.dmg.pmml.PMMLObject) localTransformations));
    }

    @Override
    public VisitorAction visit(DerivedField derivedField) {
        return visit(((org.dmg.pmml.TypeDefinitionField) derivedField));
    }

    @Override
    public VisitorAction visit(Euclidean euclidean) {
        return visit(((org.dmg.pmml.Measure) euclidean));
    }

    @Override
    public VisitorAction visit(SquaredEuclidean squaredEuclidean) {
        return visit(((org.dmg.pmml.Measure) squaredEuclidean));
    }

    @Override
    public VisitorAction visit(Chebychev chebychev) {
        return visit(((org.dmg.pmml.Measure) chebychev));
    }

    @Override
    public VisitorAction visit(CityBlock cityBlock) {
        return visit(((org.dmg.pmml.Measure) cityBlock));
    }

    @Override
    public VisitorAction visit(Minkowski minkowski) {
        return visit(((org.dmg.pmml.Measure) minkowski));
    }

    @Override
    public VisitorAction visit(SimpleMatching simpleMatching) {
        return visit(((org.dmg.pmml.Measure) simpleMatching));
    }

    @Override
    public VisitorAction visit(Jaccard jaccard) {
        return visit(((org.dmg.pmml.Measure) jaccard));
    }

    @Override
    public VisitorAction visit(Tanimoto tanimoto) {
        return visit(((org.dmg.pmml.Measure) tanimoto));
    }

    @Override
    public VisitorAction visit(BinarySimilarity binarySimilarity) {
        return visit(((org.dmg.pmml.Measure) binarySimilarity));
    }

    @Override
    public VisitorAction visit(Comparisons comparisons) {
        return visit(((org.dmg.pmml.PMMLObject) comparisons));
    }

    @Override
    public VisitorAction visit(CenterFields centerFields) {
        return visit(((org.dmg.pmml.PMMLObject) centerFields));
    }

    @Override
    public VisitorAction visit(MissingValueWeights missingValueWeights) {
        return visit(((org.dmg.pmml.PMMLObject) missingValueWeights));
    }

    @Override
    public VisitorAction visit(Cluster cluster) {
        return visit(((org.dmg.pmml.Entity) cluster));
    }

    @Override
    public VisitorAction visit(KohonenMap kohonenMap) {
        return visit(((org.dmg.pmml.PMMLObject) kohonenMap));
    }

    @Override
    public VisitorAction visit(Partition partition) {
        return visit(((org.dmg.pmml.PMMLObject) partition));
    }

    @Override
    public VisitorAction visit(Covariances covariances) {
        return visit(((org.dmg.pmml.PMMLObject) covariances));
    }

    @Override
    public VisitorAction visit(ModelVerification modelVerification) {
        return visit(((org.dmg.pmml.PMMLObject) modelVerification));
    }

    @Override
    public VisitorAction visit(VerificationFields verificationFields) {
        return visit(((org.dmg.pmml.PMMLObject) verificationFields));
    }

    @Override
    public VisitorAction visit(VerificationField verificationField) {
        return visit(((org.dmg.pmml.PMMLObject) verificationField));
    }

    @Override
    public VisitorAction visit(LinearKernelType linearKernelType) {
        return visit(((org.dmg.pmml.KernelType) linearKernelType));
    }

    @Override
    public VisitorAction visit(NeuralOutput neuralOutput) {
        return visit(((org.dmg.pmml.PMMLObject) neuralOutput));
    }

    @Override
    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
        return visit(((org.dmg.pmml.Model) supportVectorMachineModel));
    }

    @Override
    public VisitorAction visit(Targets targets) {
        return visit(((org.dmg.pmml.PMMLObject) targets));
    }

    @Override
    public VisitorAction visit(TargetValue targetValue) {
        return visit(((org.dmg.pmml.PMMLObject) targetValue));
    }

    @Override
    public VisitorAction visit(PolynomialKernelType polynomialKernelType) {
        return visit(((org.dmg.pmml.KernelType) polynomialKernelType));
    }

    @Override
    public VisitorAction visit(RadialBasisKernelType radialBasisKernelType) {
        return visit(((org.dmg.pmml.KernelType) radialBasisKernelType));
    }

    @Override
    public VisitorAction visit(SigmoidKernelType sigmoidKernelType) {
        return visit(((org.dmg.pmml.KernelType) sigmoidKernelType));
    }

    @Override
    public VisitorAction visit(VectorDictionary vectorDictionary) {
        return visit(((org.dmg.pmml.PMMLObject) vectorDictionary));
    }

    @Override
    public VisitorAction visit(VectorFields vectorFields) {
        return visit(((org.dmg.pmml.PMMLObject) vectorFields));
    }

    @Override
    public VisitorAction visit(VectorInstance vectorInstance) {
        return visit(((org.dmg.pmml.PMMLObject) vectorInstance));
    }

    @Override
    public VisitorAction visit(RealSparseArray realSparseArray) {
        return visit(((org.dmg.pmml.SparseArray) realSparseArray));
    }

    @Override
    public VisitorAction visit(SupportVectorMachine supportVectorMachine) {
        return visit(((org.dmg.pmml.PMMLObject) supportVectorMachine));
    }

    @Override
    public VisitorAction visit(SupportVectors supportVectors) {
        return visit(((org.dmg.pmml.PMMLObject) supportVectors));
    }

    @Override
    public VisitorAction visit(SupportVector supportVector) {
        return visit(((org.dmg.pmml.PMMLObject) supportVector));
    }

    @Override
    public VisitorAction visit(Coefficients coefficients) {
        return visit(((org.dmg.pmml.PMMLObject) coefficients));
    }

    @Override
    public VisitorAction visit(Coefficient coefficient) {
        return visit(((org.dmg.pmml.PMMLObject) coefficient));
    }

    @Override
    public VisitorAction visit(Item item) {
        return visit(((org.dmg.pmml.PMMLObject) item));
    }

    @Override
    public VisitorAction visit(TimeSeries timeSeries) {
        return visit(((org.dmg.pmml.PMMLObject) timeSeries));
    }

    @Override
    public VisitorAction visit(TimeAnchor timeAnchor) {
        return visit(((org.dmg.pmml.PMMLObject) timeAnchor));
    }

    @Override
    public VisitorAction visit(TimeException timeException) {
        return visit(((org.dmg.pmml.PMMLObject) timeException));
    }

    @Override
    public VisitorAction visit(TimeValue timeValue) {
        return visit(((org.dmg.pmml.PMMLObject) timeValue));
    }

    @Override
    public VisitorAction visit(Timestamp timestamp) {
        return visit(((org.dmg.pmml.PMMLObject) timestamp));
    }

    @Override
    public VisitorAction visit(NeuralInput neuralInput) {
        return visit(((org.dmg.pmml.Entity) neuralInput));
    }

    @Override
    public VisitorAction visit(ParamMatrix paramMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) paramMatrix));
    }

    @Override
    public VisitorAction visit(PCovCell pCovCell) {
        return visit(((org.dmg.pmml.PMMLObject) pCovCell));
    }

    @Override
    public VisitorAction visit(BaselineModel baselineModel) {
        return visit(((org.dmg.pmml.Model) baselineModel));
    }

    @Override
    public VisitorAction visit(TestDistributions testDistributions) {
        return visit(((org.dmg.pmml.PMMLObject) testDistributions));
    }

    @Override
    public VisitorAction visit(Baseline baseline) {
        return visit(((org.dmg.pmml.PMMLObject) baseline));
    }

    @Override
    public VisitorAction visit(AnyDistribution anyDistribution) {
        return visit(((org.dmg.pmml.ContinuousDistribution) anyDistribution));
    }

    @Override
    public VisitorAction visit(GaussianDistribution gaussianDistribution) {
        return visit(((org.dmg.pmml.ContinuousDistribution) gaussianDistribution));
    }

    @Override
    public VisitorAction visit(PoissonDistribution poissonDistribution) {
        return visit(((org.dmg.pmml.ContinuousDistribution) poissonDistribution));
    }

    @Override
    public VisitorAction visit(UniformDistribution uniformDistribution) {
        return visit(((org.dmg.pmml.ContinuousDistribution) uniformDistribution));
    }

    @Override
    public VisitorAction visit(CountTable countTable) {
        return visit(((DiscreteDistribution) countTable));
    }

    @Override
    public VisitorAction visit(Alternate alternate) {
        return visit(((org.dmg.pmml.PMMLObject) alternate));
    }

    @Override
    public VisitorAction visit(RuleSetModel ruleSetModel) {
        return visit(((org.dmg.pmml.Model) ruleSetModel));
    }

    @Override
    public VisitorAction visit(RuleSet ruleSet) {
        return visit(((org.dmg.pmml.PMMLObject) ruleSet));
    }

    @Override
    public VisitorAction visit(ScoreDistribution scoreDistribution) {
        return visit(((org.dmg.pmml.PMMLObject) scoreDistribution));
    }

    @Override
    public VisitorAction visit(SimpleRule simpleRule) {
        return visit(((org.dmg.pmml.Rule) simpleRule));
    }

    @Override
    public VisitorAction visit(CompoundRule compoundRule) {
        return visit(((org.dmg.pmml.Rule) compoundRule));
    }

    @Override
    public VisitorAction visit(TargetValueStats targetValueStats) {
        return visit(((org.dmg.pmml.PMMLObject) targetValueStats));
    }

    @Override
    public VisitorAction visit(TargetValueStat targetValueStat) {
        return visit(((org.dmg.pmml.PMMLObject) targetValueStat));
    }

    @Override
    public VisitorAction visit(Node node) {
        return visit(((org.dmg.pmml.Entity) node));
    }

    @Override
    public VisitorAction visit(Regression regression) {
        return visit(((org.dmg.pmml.EmbeddedModel) regression));
    }

    @Override
    public VisitorAction visit(ResultField resultField) {
        return visit(((org.dmg.pmml.Field) resultField));
    }

    @Override
    public VisitorAction visit(RegressionTable regressionTable) {
        return visit(((org.dmg.pmml.PMMLObject) regressionTable));
    }

    @Override
    public VisitorAction visit(NumericPredictor numericPredictor) {
        return visit(((org.dmg.pmml.Term) numericPredictor));
    }

    @Override
    public VisitorAction visit(CategoricalPredictor categoricalPredictor) {
        return visit(((org.dmg.pmml.Term) categoricalPredictor));
    }

    @Override
    public VisitorAction visit(PredictorTerm predictorTerm) {
        return visit(((org.dmg.pmml.Term) predictorTerm));
    }

    @Override
    public VisitorAction visit(EventValues eventValues) {
        return visit(((org.dmg.pmml.PMMLObject) eventValues));
    }

    @Override
    public VisitorAction visit(BayesInput bayesInput) {
        return visit(((org.dmg.pmml.PMMLObject) bayesInput));
    }

    @Override
    public VisitorAction visit(PairCounts pairCounts) {
        return visit(((org.dmg.pmml.PMMLObject) pairCounts));
    }

    @Override
    public VisitorAction visit(TargetValueCounts targetValueCounts) {
        return visit(((org.dmg.pmml.PMMLObject) targetValueCounts));
    }

    @Override
    public VisitorAction visit(TargetValueCount targetValueCount) {
        return visit(((org.dmg.pmml.PMMLObject) targetValueCount));
    }

    @Override
    public VisitorAction visit(Header header) {
        return visit(((org.dmg.pmml.PMMLObject) header));
    }

    @Override
    public VisitorAction visit(Application application) {
        return visit(((org.dmg.pmml.PMMLObject) application));
    }

    @Override
    public VisitorAction visit(Annotation annotation) {
        return visit(((org.dmg.pmml.PMMLObject) annotation));
    }

    @Override
    public VisitorAction visit(PPMatrix ppMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) ppMatrix));
    }

    @Override
    public VisitorAction visit(PPCell ppCell) {
        return visit(((org.dmg.pmml.ParameterCell) ppCell));
    }

    @Override
    public VisitorAction visit(SeasonalityExpoSmooth seasonalityExpoSmooth) {
        return visit(((org.dmg.pmml.PMMLObject) seasonalityExpoSmooth));
    }

    @Override
    public VisitorAction visit(InstanceField instanceField) {
        return visit(((org.dmg.pmml.PMMLObject) instanceField));
    }

    @Override
    public VisitorAction visit(NearestNeighborModel nearestNeighborModel) {
        return visit(((org.dmg.pmml.Model) nearestNeighborModel));
    }

    @Override
    public VisitorAction visit(TrainingInstances trainingInstances) {
        return visit(((org.dmg.pmml.PMMLObject) trainingInstances));
    }

    @Override
    public VisitorAction visit(InstanceFields instanceFields) {
        return visit(((org.dmg.pmml.PMMLObject) instanceFields));
    }

    @Override
    public VisitorAction visit(KNNInputs knnInputs) {
        return visit(((org.dmg.pmml.PMMLObject) knnInputs));
    }

    @Override
    public VisitorAction visit(KNNInput knnInput) {
        return visit(((org.dmg.pmml.ComparisonField) knnInput));
    }

    @Override
    public VisitorAction visit(Segmentation segmentation) {
        return visit(((org.dmg.pmml.PMMLObject) segmentation));
    }

    @Override
    public VisitorAction visit(Segment segment) {
        return visit(((org.dmg.pmml.Entity) segment));
    }

    @Override
    public VisitorAction visit(AssociationModel associationModel) {
        return visit(((org.dmg.pmml.Model) associationModel));
    }

    @Override
    public VisitorAction visit(Itemset itemset) {
        return visit(((org.dmg.pmml.PMMLObject) itemset));
    }

    @Override
    public VisitorAction visit(AssociationRule associationRule) {
        return visit(((org.dmg.pmml.Entity) associationRule));
    }

    @Override
    public VisitorAction visit(ParameterList parameterList) {
        return visit(((org.dmg.pmml.PMMLObject) parameterList));
    }

    @Override
    public VisitorAction visit(Parameter parameter) {
        return visit(((org.dmg.pmml.PMMLObject) parameter));
    }

    @Override
    public VisitorAction visit(FactorList factorList) {
        return visit(((org.dmg.pmml.PredictorList) factorList));
    }

    @Override
    public VisitorAction visit(Predictor predictor) {
        return visit(((org.dmg.pmml.PMMLObject) predictor));
    }

    @Override
    public VisitorAction visit(Categories categories) {
        return visit(((org.dmg.pmml.PMMLObject) categories));
    }

    @Override
    public VisitorAction visit(Category category) {
        return visit(((org.dmg.pmml.PMMLObject) category));
    }

    @Override
    public VisitorAction visit(CovariateList covariateList) {
        return visit(((org.dmg.pmml.PredictorList) covariateList));
    }

    @Override
    public VisitorAction visit(BaseCumHazardTables baseCumHazardTables) {
        return visit(((org.dmg.pmml.PMMLObject) baseCumHazardTables));
    }

    @Override
    public VisitorAction visit(BaselineStratum baselineStratum) {
        return visit(((org.dmg.pmml.PMMLObject) baselineStratum));
    }

    @Override
    public VisitorAction visit(BaselineCell baselineCell) {
        return visit(((org.dmg.pmml.PMMLObject) baselineCell));
    }

    @Override
    public VisitorAction visit(MiningModel miningModel) {
        return visit(((org.dmg.pmml.Model) miningModel));
    }

    @Override
    public VisitorAction visit(NaiveBayesModel naiveBayesModel) {
        return visit(((org.dmg.pmml.Model) naiveBayesModel));
    }

    @Override
    public VisitorAction visit(BayesInputs bayesInputs) {
        return visit(((org.dmg.pmml.PMMLObject) bayesInputs));
    }

    @Override
    public VisitorAction visit(BayesOutput bayesOutput) {
        return visit(((org.dmg.pmml.PMMLObject) bayesOutput));
    }

    @Override
    public VisitorAction visit(NeuralNetwork neuralNetwork) {
        return visit(((org.dmg.pmml.Model) neuralNetwork));
    }

    @Override
    public VisitorAction visit(NeuralInputs neuralInputs) {
        return visit(((org.dmg.pmml.PMMLObject) neuralInputs));
    }

    @Override
    public VisitorAction visit(NeuralLayer neuralLayer) {
        return visit(((org.dmg.pmml.PMMLObject) neuralLayer));
    }

    @Override
    public VisitorAction visit(Neuron neuron) {
        return visit(((org.dmg.pmml.Entity) neuron));
    }

    @Override
    public VisitorAction visit(Connection connection) {
        return visit(((org.dmg.pmml.PMMLObject) connection));
    }

    @Override
    public VisitorAction visit(NeuralOutputs neuralOutputs) {
        return visit(((org.dmg.pmml.PMMLObject) neuralOutputs));
    }

    @Override
    public VisitorAction visit(SequenceModel sequenceModel) {
        return visit(((org.dmg.pmml.Model) sequenceModel));
    }

    @Override
    public VisitorAction visit(Constraints constraints) {
        return visit(((org.dmg.pmml.PMMLObject) constraints));
    }

    @Override
    public VisitorAction visit(SetPredicate setPredicate) {
        return visit(((org.dmg.pmml.PMMLObject) setPredicate));
    }

    @Override
    public VisitorAction visit(Sequence sequence) {
        return visit(((org.dmg.pmml.PMMLObject) sequence));
    }

    @Override
    public VisitorAction visit(SetReference setReference) {
        return visit(((org.dmg.pmml.PMMLObject) setReference));
    }

    @Override
    public VisitorAction visit(Delimiter delimiter) {
        return visit(((org.dmg.pmml.PMMLObject) delimiter));
    }

    @Override
    public VisitorAction visit(Time time) {
        return visit(((org.dmg.pmml.PMMLObject) time));
    }

    @Override
    public VisitorAction visit(SequenceRule sequenceRule) {
        return visit(((org.dmg.pmml.Entity) sequenceRule));
    }

    @Override
    public VisitorAction visit(AntecedentSequence antecedentSequence) {
        return visit(((org.dmg.pmml.PMMLObject) antecedentSequence));
    }

    @Override
    public VisitorAction visit(SequenceReference sequenceReference) {
        return visit(((org.dmg.pmml.PMMLObject) sequenceReference));
    }

    @Override
    public VisitorAction visit(ConsequentSequence consequentSequence) {
        return visit(((org.dmg.pmml.PMMLObject) consequentSequence));
    }

    @Override
    public VisitorAction visit(TextModel textModel) {
        return visit(((org.dmg.pmml.Model) textModel));
    }

    @Override
    public VisitorAction visit(TextDictionary textDictionary) {
        return visit(((org.dmg.pmml.PMMLObject) textDictionary));
    }

    @Override
    public VisitorAction visit(Taxonomy taxonomy) {
        return visit(((org.dmg.pmml.PMMLObject) taxonomy));
    }

    @Override
    public VisitorAction visit(TextCorpus textCorpus) {
        return visit(((org.dmg.pmml.PMMLObject) textCorpus));
    }

    @Override
    public VisitorAction visit(TextDocument textDocument) {
        return visit(((org.dmg.pmml.PMMLObject) textDocument));
    }

    @Override
    public VisitorAction visit(DocumentTermMatrix documentTermMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) documentTermMatrix));
    }

    @Override
    public VisitorAction visit(TimeSeriesModel timeSeriesModel) {
        return visit(((org.dmg.pmml.Model) timeSeriesModel));
    }

    @Override
    public VisitorAction visit(ExponentialSmoothing exponentialSmoothing) {
        return visit(((org.dmg.pmml.PMMLObject) exponentialSmoothing));
    }

    @Override
    public VisitorAction visit(Level level) {
        return visit(((org.dmg.pmml.PMMLObject) level));
    }

    @Override
    public VisitorAction visit(DataDictionary dataDictionary) {
        return visit(((org.dmg.pmml.PMMLObject) dataDictionary));
    }

    @Override
    public VisitorAction visit(FieldValue fieldValue) {
        return visit(((org.dmg.pmml.PMMLObject) fieldValue));
    }

    @Override
    public VisitorAction visit(FieldValueCount fieldValueCount) {
        return visit(((org.dmg.pmml.PMMLObject) fieldValueCount));
    }

    @Override
    public VisitorAction visit(TransformationDictionary transformationDictionary) {
        return visit(((org.dmg.pmml.PMMLObject) transformationDictionary));
    }

    @Override
    public VisitorAction visit(DefineFunction defineFunction) {
        return visit(((org.dmg.pmml.PMMLObject) defineFunction));
    }

    @Override
    public VisitorAction visit(ParameterField parameterField) {
        return visit(((org.dmg.pmml.Field) parameterField));
    }

    @Override
    public VisitorAction visit(IntSparseArray intSparseArray) {
        return visit(((org.dmg.pmml.SparseArray) intSparseArray));
    }

    @Override
    public VisitorAction visit(PMML pmml) {
        return visit(((org.dmg.pmml.PMMLObject) pmml));
    }

    @Override
    public VisitorAction visit(MiningBuildTask miningBuildTask) {
        return visit(((org.dmg.pmml.PMMLObject) miningBuildTask));
    }

}
