
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TargetValueCounts"/>
 *       &lt;/sequence>
 *       &lt;attribute name="fieldName" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValueCounts"
})
@XmlRootElement(name = "BayesOutput", namespace = "http://www.dmg.org/PMML-4_2")
public class BayesOutput
    extends PMMLObject
    implements HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "TargetValueCounts", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected TargetValueCounts targetValueCounts;
    @XmlAttribute(name = "fieldName", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    protected FieldName fieldName;

    public BayesOutput() {
        super();
    }

    public BayesOutput(final TargetValueCounts targetValueCounts, final FieldName fieldName) {
        super();
        this.targetValueCounts = targetValueCounts;
        this.fieldName = fieldName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the targetValueCounts property.
     * 
     * @return
     *     possible object is
     *     {@link TargetValueCounts }
     *     
     */
    public TargetValueCounts getTargetValueCounts() {
        return targetValueCounts;
    }

    /**
     * Sets the value of the targetValueCounts property.
     * 
     * @param value
     *     allowed object is
     *     {@link TargetValueCounts }
     *     
     */
    public void setTargetValueCounts(TargetValueCounts value) {
        this.targetValueCounts = value;
    }

    /**
     * Gets the value of the fieldName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getFieldName() {
        return fieldName;
    }

    /**
     * Sets the value of the fieldName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFieldName(FieldName value) {
        this.fieldName = value;
    }

    public BayesOutput withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public BayesOutput withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public BayesOutput withTargetValueCounts(TargetValueCounts value) {
        setTargetValueCounts(value);
        return this;
    }

    public BayesOutput withFieldName(FieldName value) {
        setFieldName(value);
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.targetValueCounts!= null)) {
            status = this.targetValueCounts.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
