
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;sequence maxOccurs="unbounded" minOccurs="2">
 *           &lt;group ref="{http://www.dmg.org/PMML-4_2}PREDICATE"/>
 *         &lt;/sequence>
 *       &lt;/sequence>
 *       &lt;attribute name="booleanOperator" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="or"/>
 *             &lt;enumeration value="and"/>
 *             &lt;enumeration value="xor"/>
 *             &lt;enumeration value="surrogate"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predicates"
})
@XmlRootElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_2")
public class CompoundPredicate
    extends Predicate
    implements HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_2", type = SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_2", type = CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_2", type = SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_2", type = True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_2", type = False.class)
    })
    protected List<Predicate> predicates;
    @XmlAttribute(name = "booleanOperator", required = true)
    protected CompoundPredicate.BooleanOperator booleanOperator;

    public CompoundPredicate() {
        super();
    }

    public CompoundPredicate(final CompoundPredicate.BooleanOperator booleanOperator) {
        super();
        this.booleanOperator = booleanOperator;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the predicates property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the predicates property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPredicates().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SimplePredicate }
     * {@link CompoundPredicate }
     * {@link SimpleSetPredicate }
     * {@link True }
     * {@link False }
     * 
     * 
     */
    public List<Predicate> getPredicates() {
        if (predicates == null) {
            predicates = new ArrayList<Predicate>();
        }
        return this.predicates;
    }

    /**
     * Gets the value of the booleanOperator property.
     * 
     * @return
     *     possible object is
     *     {@link CompoundPredicate.BooleanOperator }
     *     
     */
    public CompoundPredicate.BooleanOperator getBooleanOperator() {
        return booleanOperator;
    }

    /**
     * Sets the value of the booleanOperator property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompoundPredicate.BooleanOperator }
     *     
     */
    public void setBooleanOperator(CompoundPredicate.BooleanOperator value) {
        this.booleanOperator = value;
    }

    public CompoundPredicate withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public CompoundPredicate withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public CompoundPredicate withPredicates(Predicate... values) {
        if (values!= null) {
            for (Predicate value: values) {
                getPredicates().add(value);
            }
        }
        return this;
    }

    public CompoundPredicate withPredicates(Collection<Predicate> values) {
        if (values!= null) {
            getPredicates().addAll(values);
        }
        return this;
    }

    public CompoundPredicate withBooleanOperator(CompoundPredicate.BooleanOperator value) {
        setBooleanOperator(value);
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public boolean hasPredicates() {
        return ((this.predicates!= null)&&(this.predicates.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.predicates!= null))&&(i<this.predicates.size())); i ++) {
            status = this.predicates.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="or"/>
     *     &lt;enumeration value="and"/>
     *     &lt;enumeration value="xor"/>
     *     &lt;enumeration value="surrogate"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum BooleanOperator {

        @XmlEnumValue("or")
        OR("or"),
        @XmlEnumValue("and")
        AND("and"),
        @XmlEnumValue("xor")
        XOR("xor"),
        @XmlEnumValue("surrogate")
        SURROGATE("surrogate");
        private final String value;

        BooleanOperator(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static CompoundPredicate.BooleanOperator fromValue(String v) {
            for (CompoundPredicate.BooleanOperator c: CompoundPredicate.BooleanOperator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
