
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Interval" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}FrequenciesType" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="totalValuesSum" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="totalSquaresSum" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "intervals",
    "arrays"
})
@XmlRootElement(name = "ContStats", namespace = "http://www.dmg.org/PMML-4_2")
public class ContStats
    extends PMMLObject
    implements HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "Interval", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Interval> intervals;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Array> arrays;
    @XmlAttribute(name = "totalValuesSum")
    protected Double totalValuesSum;
    @XmlAttribute(name = "totalSquaresSum")
    protected Double totalSquaresSum;

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the intervals property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the intervals property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIntervals().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Interval }
     * 
     * 
     */
    public List<Interval> getIntervals() {
        if (intervals == null) {
            intervals = new ArrayList<Interval>();
        }
        return this.intervals;
    }

    /**
     * Gets the value of the arrays property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the arrays property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getArrays().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Array }
     * 
     * 
     */
    public List<Array> getArrays() {
        if (arrays == null) {
            arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    /**
     * Gets the value of the totalValuesSum property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getTotalValuesSum() {
        return totalValuesSum;
    }

    /**
     * Sets the value of the totalValuesSum property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setTotalValuesSum(Double value) {
        this.totalValuesSum = value;
    }

    /**
     * Gets the value of the totalSquaresSum property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getTotalSquaresSum() {
        return totalSquaresSum;
    }

    /**
     * Sets the value of the totalSquaresSum property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setTotalSquaresSum(Double value) {
        this.totalSquaresSum = value;
    }

    public ContStats withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public ContStats withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public ContStats withIntervals(Interval... values) {
        if (values!= null) {
            for (Interval value: values) {
                getIntervals().add(value);
            }
        }
        return this;
    }

    public ContStats withIntervals(Collection<Interval> values) {
        if (values!= null) {
            getIntervals().addAll(values);
        }
        return this;
    }

    public ContStats withArrays(Array... values) {
        if (values!= null) {
            for (Array value: values) {
                getArrays().add(value);
            }
        }
        return this;
    }

    public ContStats withArrays(Collection<Array> values) {
        if (values!= null) {
            getArrays().addAll(values);
        }
        return this;
    }

    public ContStats withTotalValuesSum(Double value) {
        setTotalValuesSum(value);
        return this;
    }

    public ContStats withTotalSquaresSum(Double value) {
        setTotalSquaresSum(value);
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public boolean hasIntervals() {
        return ((this.intervals!= null)&&(this.intervals.size()> 0));
    }

    public boolean hasArrays() {
        return ((this.arrays!= null)&&(this.arrays.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.intervals!= null))&&(i<this.intervals.size())); i ++) {
            status = this.intervals.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.arrays!= null))&&(i<this.arrays.size())); i ++) {
            status = this.arrays.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
