
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}VerificationFields"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}InlineTable"/>
 *       &lt;/sequence>
 *       &lt;attribute name="recordCount" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="fieldCount" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "verificationFields",
    "inlineTable"
})
@XmlRootElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_2")
public class ModelVerification
    extends PMMLObject
    implements HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "VerificationFields", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected VerificationFields verificationFields;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected InlineTable inlineTable;
    @XmlAttribute(name = "recordCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer recordCount;
    @XmlAttribute(name = "fieldCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer fieldCount;

    public ModelVerification() {
        super();
    }

    public ModelVerification(final VerificationFields verificationFields, final InlineTable inlineTable) {
        super();
        this.verificationFields = verificationFields;
        this.inlineTable = inlineTable;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the verificationFields property.
     * 
     * @return
     *     possible object is
     *     {@link VerificationFields }
     *     
     */
    public VerificationFields getVerificationFields() {
        return verificationFields;
    }

    /**
     * Sets the value of the verificationFields property.
     * 
     * @param value
     *     allowed object is
     *     {@link VerificationFields }
     *     
     */
    public void setVerificationFields(VerificationFields value) {
        this.verificationFields = value;
    }

    /**
     * Gets the value of the inlineTable property.
     * 
     * @return
     *     possible object is
     *     {@link InlineTable }
     *     
     */
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    /**
     * Sets the value of the inlineTable property.
     * 
     * @param value
     *     allowed object is
     *     {@link InlineTable }
     *     
     */
    public void setInlineTable(InlineTable value) {
        this.inlineTable = value;
    }

    /**
     * Gets the value of the recordCount property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getRecordCount() {
        return recordCount;
    }

    /**
     * Sets the value of the recordCount property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRecordCount(Integer value) {
        this.recordCount = value;
    }

    /**
     * Gets the value of the fieldCount property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getFieldCount() {
        return fieldCount;
    }

    /**
     * Sets the value of the fieldCount property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFieldCount(Integer value) {
        this.fieldCount = value;
    }

    public ModelVerification withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public ModelVerification withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public ModelVerification withVerificationFields(VerificationFields value) {
        setVerificationFields(value);
        return this;
    }

    public ModelVerification withInlineTable(InlineTable value) {
        setInlineTable(value);
        return this;
    }

    public ModelVerification withRecordCount(Integer value) {
        setRecordCount(value);
        return this;
    }

    public ModelVerification withFieldCount(Integer value) {
        setFieldCount(value);
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.verificationFields!= null)) {
            status = this.verificationFields.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.inlineTable!= null)) {
            status = this.inlineTable.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
