
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ComparisonMeasure"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ClusteringField" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}CenterFields" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MissingValueWeights" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Cluster" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="modelClass" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="centerBased"/>
 *             &lt;enumeration value="distributionBased"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="numberOfClusters" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "localTransformations",
    "comparisonMeasure",
    "clusteringFields",
    "centerFields",
    "missingValueWeights",
    "clusters",
    "modelVerification"
})
@XmlRootElement(name = "ClusteringModel")
public class ClusteringModel
    extends Model
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    @Added(Version.PMML_4_0)
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "ComparisonMeasure", required = true)
    protected ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "ClusteringField", required = true)
    protected List<ClusteringField> clusteringFields;
    @XmlElement(name = "CenterFields")
    @Removed(Version.PMML_3_2)
    protected CenterFields centerFields;
    @XmlElement(name = "MissingValueWeights")
    protected MissingValueWeights missingValueWeights;
    @XmlElement(name = "Cluster", required = true)
    protected List<Cluster> clusters;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "modelClass", required = true)
    protected ClusteringModel.ModelClass modelClass;
    @XmlAttribute(name = "numberOfClusters", required = true)
    protected int numberOfClusters;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    protected Boolean scorable;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public ClusteringModel() {
        super();
    }

    public ClusteringModel(final MiningSchema miningSchema, final ComparisonMeasure comparisonMeasure, final MiningFunctionType functionName, final ClusteringModel.ModelClass modelClass, final int numberOfClusters) {
        super();
        this.miningSchema = miningSchema;
        this.comparisonMeasure = comparisonMeasure;
        this.functionName = functionName;
        this.modelClass = modelClass;
        this.numberOfClusters = numberOfClusters;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the comparisonMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link ComparisonMeasure }
     *     
     */
    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    /**
     * Sets the value of the comparisonMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link ComparisonMeasure }
     *     
     */
    public void setComparisonMeasure(ComparisonMeasure value) {
        this.comparisonMeasure = value;
    }

    /**
     * Gets the value of the clusteringFields property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the clusteringFields property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClusteringFields().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ClusteringField }
     * 
     * 
     */
    public List<ClusteringField> getClusteringFields() {
        if (clusteringFields == null) {
            clusteringFields = new ArrayList<ClusteringField>();
        }
        return this.clusteringFields;
    }

    /**
     * Gets the value of the centerFields property.
     * 
     * @return
     *     possible object is
     *     {@link CenterFields }
     *     
     */
    public CenterFields getCenterFields() {
        return centerFields;
    }

    /**
     * Sets the value of the centerFields property.
     * 
     * @param value
     *     allowed object is
     *     {@link CenterFields }
     *     
     */
    public void setCenterFields(CenterFields value) {
        this.centerFields = value;
    }

    /**
     * Gets the value of the missingValueWeights property.
     * 
     * @return
     *     possible object is
     *     {@link MissingValueWeights }
     *     
     */
    public MissingValueWeights getMissingValueWeights() {
        return missingValueWeights;
    }

    /**
     * Sets the value of the missingValueWeights property.
     * 
     * @param value
     *     allowed object is
     *     {@link MissingValueWeights }
     *     
     */
    public void setMissingValueWeights(MissingValueWeights value) {
        this.missingValueWeights = value;
    }

    /**
     * Gets the value of the clusters property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the clusters property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClusters().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Cluster }
     * 
     * 
     */
    public List<Cluster> getClusters() {
        if (clusters == null) {
            clusters = new ArrayList<Cluster>();
        }
        return this.clusters;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the modelClass property.
     * 
     * @return
     *     possible object is
     *     {@link ClusteringModel.ModelClass }
     *     
     */
    public ClusteringModel.ModelClass getModelClass() {
        return modelClass;
    }

    /**
     * Sets the value of the modelClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link ClusteringModel.ModelClass }
     *     
     */
    public void setModelClass(ClusteringModel.ModelClass value) {
        this.modelClass = value;
    }

    /**
     * Gets the value of the numberOfClusters property.
     * 
     */
    public int getNumberOfClusters() {
        return numberOfClusters;
    }

    /**
     * Sets the value of the numberOfClusters property.
     * 
     */
    public void setNumberOfClusters(int value) {
        this.numberOfClusters = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public ClusteringModel withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public ClusteringModel withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public ClusteringModel withMiningSchema(MiningSchema value) {
        setMiningSchema(value);
        return this;
    }

    public ClusteringModel withOutput(Output value) {
        setOutput(value);
        return this;
    }

    public ClusteringModel withModelStats(ModelStats value) {
        setModelStats(value);
        return this;
    }

    public ClusteringModel withModelExplanation(ModelExplanation value) {
        setModelExplanation(value);
        return this;
    }

    public ClusteringModel withLocalTransformations(LocalTransformations value) {
        setLocalTransformations(value);
        return this;
    }

    public ClusteringModel withComparisonMeasure(ComparisonMeasure value) {
        setComparisonMeasure(value);
        return this;
    }

    public ClusteringModel withClusteringFields(ClusteringField... values) {
        if (values!= null) {
            for (ClusteringField value: values) {
                getClusteringFields().add(value);
            }
        }
        return this;
    }

    public ClusteringModel withClusteringFields(Collection<ClusteringField> values) {
        if (values!= null) {
            getClusteringFields().addAll(values);
        }
        return this;
    }

    public ClusteringModel withCenterFields(CenterFields value) {
        setCenterFields(value);
        return this;
    }

    public ClusteringModel withMissingValueWeights(MissingValueWeights value) {
        setMissingValueWeights(value);
        return this;
    }

    public ClusteringModel withClusters(Cluster... values) {
        if (values!= null) {
            for (Cluster value: values) {
                getClusters().add(value);
            }
        }
        return this;
    }

    public ClusteringModel withClusters(Collection<Cluster> values) {
        if (values!= null) {
            getClusters().addAll(values);
        }
        return this;
    }

    public ClusteringModel withModelVerification(ModelVerification value) {
        setModelVerification(value);
        return this;
    }

    public ClusteringModel withModelName(String value) {
        setModelName(value);
        return this;
    }

    public ClusteringModel withFunctionName(MiningFunctionType value) {
        setFunctionName(value);
        return this;
    }

    public ClusteringModel withAlgorithmName(String value) {
        setAlgorithmName(value);
        return this;
    }

    public ClusteringModel withModelClass(ClusteringModel.ModelClass value) {
        setModelClass(value);
        return this;
    }

    public ClusteringModel withNumberOfClusters(int value) {
        setNumberOfClusters(value);
        return this;
    }

    public ClusteringModel withScorable(Boolean value) {
        setScorable(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public Targets getTargets() {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the value of the targets property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public void setTargets(Targets targets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.miningSchema!= null)) {
            status = this.miningSchema.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.output!= null)) {
            status = this.output.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelStats!= null)) {
            status = this.modelStats.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelExplanation!= null)) {
            status = this.modelExplanation.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.localTransformations!= null)) {
            status = this.localTransformations.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.comparisonMeasure!= null)) {
            status = this.comparisonMeasure.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.clusteringFields!= null))&&(i<this.clusteringFields.size())); i ++) {
            status = this.clusteringFields.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.centerFields!= null)) {
            status = this.centerFields.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.missingValueWeights!= null)) {
            status = this.missingValueWeights.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.clusters!= null))&&(i<this.clusters.size())); i ++) {
            status = this.clusters.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelVerification!= null)) {
            status = this.modelVerification.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="centerBased"/>
     *     &lt;enumeration value="distributionBased"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum ModelClass {

        @XmlEnumValue("centerBased")
        CENTER_BASED("centerBased"),
        @XmlEnumValue("distributionBased")
        DISTRIBUTION_BASED("distributionBased");
        private final String value;

        ModelClass(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ClusteringModel.ModelClass fromValue(String v) {
            for (ClusteringModel.ModelClass c: ClusteringModel.ModelClass.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
