
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}euclidean"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}squaredEuclidean"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}chebychev"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}cityBlock"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}minkowski"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}simpleMatching"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}jaccard"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}tanimoto"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}binarySimilarity"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="kind" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="distance"/>
 *             &lt;enumeration value="similarity"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="compareFunction" type="{http://www.dmg.org/PMML-4_2}COMPARE-FUNCTION" default="absDiff" />
 *       &lt;attribute name="minimum" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="maximum" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "measure"
})
@XmlRootElement(name = "ComparisonMeasure")
public class ComparisonMeasure
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "euclidean", type = Euclidean.class),
        @XmlElement(name = "squaredEuclidean", type = SquaredEuclidean.class),
        @XmlElement(name = "chebychev", type = Chebychev.class),
        @XmlElement(name = "cityBlock", type = CityBlock.class),
        @XmlElement(name = "minkowski", type = Minkowski.class),
        @XmlElement(name = "simpleMatching", type = SimpleMatching.class),
        @XmlElement(name = "jaccard", type = Jaccard.class),
        @XmlElement(name = "tanimoto", type = Tanimoto.class),
        @XmlElement(name = "binarySimilarity", type = BinarySimilarity.class)
    })
    protected Measure measure;
    @XmlAttribute(name = "kind", required = true)
    protected ComparisonMeasure.Kind kind;
    @XmlAttribute(name = "compareFunction")
    protected CompareFunctionType compareFunction;
    @XmlAttribute(name = "minimum")
    protected Double minimum;
    @XmlAttribute(name = "maximum")
    protected Double maximum;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public ComparisonMeasure() {
        super();
    }

    public ComparisonMeasure(final ComparisonMeasure.Kind kind) {
        super();
        this.kind = kind;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the measure property.
     * 
     * @return
     *     possible object is
     *     {@link Euclidean }
     *     {@link SquaredEuclidean }
     *     {@link Chebychev }
     *     {@link CityBlock }
     *     {@link Minkowski }
     *     {@link SimpleMatching }
     *     {@link Jaccard }
     *     {@link Tanimoto }
     *     {@link BinarySimilarity }
     *     
     */
    public Measure getMeasure() {
        return measure;
    }

    /**
     * Sets the value of the measure property.
     * 
     * @param value
     *     allowed object is
     *     {@link Euclidean }
     *     {@link SquaredEuclidean }
     *     {@link Chebychev }
     *     {@link CityBlock }
     *     {@link Minkowski }
     *     {@link SimpleMatching }
     *     {@link Jaccard }
     *     {@link Tanimoto }
     *     {@link BinarySimilarity }
     *     
     */
    public void setMeasure(Measure value) {
        this.measure = value;
    }

    /**
     * Gets the value of the kind property.
     * 
     * @return
     *     possible object is
     *     {@link ComparisonMeasure.Kind }
     *     
     */
    public ComparisonMeasure.Kind getKind() {
        return kind;
    }

    /**
     * Sets the value of the kind property.
     * 
     * @param value
     *     allowed object is
     *     {@link ComparisonMeasure.Kind }
     *     
     */
    public void setKind(ComparisonMeasure.Kind value) {
        this.kind = value;
    }

    /**
     * Gets the value of the compareFunction property.
     * 
     * @return
     *     possible object is
     *     {@link CompareFunctionType }
     *     
     */
    public CompareFunctionType getCompareFunction() {
        if (compareFunction == null) {
            return CompareFunctionType.ABS_DIFF;
        } else {
            return compareFunction;
        }
    }

    /**
     * Sets the value of the compareFunction property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompareFunctionType }
     *     
     */
    public void setCompareFunction(CompareFunctionType value) {
        this.compareFunction = value;
    }

    /**
     * Gets the value of the minimum property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMinimum() {
        return minimum;
    }

    /**
     * Sets the value of the minimum property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMinimum(Double value) {
        this.minimum = value;
    }

    /**
     * Gets the value of the maximum property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMaximum() {
        return maximum;
    }

    /**
     * Sets the value of the maximum property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMaximum(Double value) {
        this.maximum = value;
    }

    public ComparisonMeasure withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public ComparisonMeasure withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public ComparisonMeasure withMeasure(Measure value) {
        setMeasure(value);
        return this;
    }

    public ComparisonMeasure withKind(ComparisonMeasure.Kind value) {
        setKind(value);
        return this;
    }

    public ComparisonMeasure withCompareFunction(CompareFunctionType value) {
        setCompareFunction(value);
        return this;
    }

    public ComparisonMeasure withMinimum(Double value) {
        setMinimum(value);
        return this;
    }

    public ComparisonMeasure withMaximum(Double value) {
        setMaximum(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.measure!= null)) {
            status = this.measure.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="distance"/>
     *     &lt;enumeration value="similarity"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Kind {

        @XmlEnumValue("distance")
        DISTANCE("distance"),
        @XmlEnumValue("similarity")
        SIMILARITY("similarity");
        private final String value;

        Kind(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ComparisonMeasure.Kind fromValue(String v) {
            for (ComparisonMeasure.Kind c: ComparisonMeasure.Kind.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
