
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Segment" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="multipleModelMethod" use="required" type="{http://www.dmg.org/PMML-4_2}MULTIPLE-MODEL-METHOD" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "localTransformations",
    "segments"
})
@XmlRootElement(name = "Segmentation")
@Added(Version.PMML_4_0)
public class Segmentation
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "LocalTransformations")
    @Removed(Version.PMML_4_1)
    protected LocalTransformations localTransformations;
    @XmlElement(name = "Segment", required = true)
    protected List<Segment> segments;
    @XmlAttribute(name = "multipleModelMethod", required = true)
    protected MultipleModelMethodType multipleModelMethod;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public Segmentation() {
        super();
    }

    public Segmentation(final MultipleModelMethodType multipleModelMethod) {
        super();
        this.multipleModelMethod = multipleModelMethod;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the segments property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the segments property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSegments().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Segment }
     * 
     * 
     */
    public List<Segment> getSegments() {
        if (segments == null) {
            segments = new ArrayList<Segment>();
        }
        return this.segments;
    }

    /**
     * Gets the value of the multipleModelMethod property.
     * 
     * @return
     *     possible object is
     *     {@link MultipleModelMethodType }
     *     
     */
    public MultipleModelMethodType getMultipleModelMethod() {
        return multipleModelMethod;
    }

    /**
     * Sets the value of the multipleModelMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link MultipleModelMethodType }
     *     
     */
    public void setMultipleModelMethod(MultipleModelMethodType value) {
        this.multipleModelMethod = value;
    }

    public Segmentation withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public Segmentation withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public Segmentation withLocalTransformations(LocalTransformations value) {
        setLocalTransformations(value);
        return this;
    }

    public Segmentation withSegments(Segment... values) {
        if (values!= null) {
            for (Segment value: values) {
                getSegments().add(value);
            }
        }
        return this;
    }

    public Segmentation withSegments(Collection<Segment> values) {
        if (values!= null) {
            getSegments().addAll(values);
        }
        return this;
    }

    public Segmentation withMultipleModelMethod(MultipleModelMethodType value) {
        setMultipleModelMethod(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.localTransformations!= null)) {
            status = this.localTransformations.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.segments!= null))&&(i<this.segments.size())); i ++) {
            status = this.segments.get(i).accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
