
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="operator" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="equal"/>
 *             &lt;enumeration value="notEqual"/>
 *             &lt;enumeration value="lessThan"/>
 *             &lt;enumeration value="lessOrEqual"/>
 *             &lt;enumeration value="greaterThan"/>
 *             &lt;enumeration value="greaterOrEqual"/>
 *             &lt;enumeration value="isMissing"/>
 *             &lt;enumeration value="isNotMissing"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="value" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "SimplePredicate")
public class SimplePredicate
    extends Predicate
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    protected FieldName field;
    @XmlAttribute(name = "operator", required = true)
    protected SimplePredicate.Operator operator;
    @XmlAttribute(name = "value")
    protected String value;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public SimplePredicate() {
        super();
    }

    public SimplePredicate(final FieldName field, final SimplePredicate.Operator operator) {
        super();
        this.field = field;
        this.operator = operator;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setField(FieldName value) {
        this.field = value;
    }

    /**
     * Gets the value of the operator property.
     * 
     * @return
     *     possible object is
     *     {@link SimplePredicate.Operator }
     *     
     */
    public SimplePredicate.Operator getOperator() {
        return operator;
    }

    /**
     * Sets the value of the operator property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimplePredicate.Operator }
     *     
     */
    public void setOperator(SimplePredicate.Operator value) {
        this.operator = value;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(String value) {
        this.value = value;
    }

    public SimplePredicate withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public SimplePredicate withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public SimplePredicate withField(FieldName value) {
        setField(value);
        return this;
    }

    public SimplePredicate withOperator(SimplePredicate.Operator value) {
        setOperator(value);
        return this;
    }

    public SimplePredicate withValue(String value) {
        setValue(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="equal"/>
     *     &lt;enumeration value="notEqual"/>
     *     &lt;enumeration value="lessThan"/>
     *     &lt;enumeration value="lessOrEqual"/>
     *     &lt;enumeration value="greaterThan"/>
     *     &lt;enumeration value="greaterOrEqual"/>
     *     &lt;enumeration value="isMissing"/>
     *     &lt;enumeration value="isNotMissing"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Operator {

        @XmlEnumValue("equal")
        EQUAL("equal"),
        @XmlEnumValue("notEqual")
        NOT_EQUAL("notEqual"),
        @XmlEnumValue("lessThan")
        LESS_THAN("lessThan"),
        @XmlEnumValue("lessOrEqual")
        LESS_OR_EQUAL("lessOrEqual"),
        @XmlEnumValue("greaterThan")
        GREATER_THAN("greaterThan"),
        @XmlEnumValue("greaterOrEqual")
        GREATER_OR_EQUAL("greaterOrEqual"),
        @XmlEnumValue("isMissing")
        IS_MISSING("isMissing"),
        @XmlEnumValue("isNotMissing")
        IS_NOT_MISSING("isNotMissing");
        private final String value;

        Operator(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static SimplePredicate.Operator fromValue(String v) {
            for (SimplePredicate.Operator c: SimplePredicate.Operator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
