
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextIndexNormalization" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}EXPRESSION"/>
 *       &lt;/sequence>
 *       &lt;attribute name="textField" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="localTermWeights" default="termFrequency">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="termFrequency"/>
 *             &lt;enumeration value="binary"/>
 *             &lt;enumeration value="logarithmic"/>
 *             &lt;enumeration value="augmentedNormalizedTermFrequency"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="isCaseSensitive" type="{http://www.w3.org/2001/XMLSchema}string" default="false" />
 *       &lt;attribute name="maxLevenshteinDistance" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       &lt;attribute name="countHits" default="allHits">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="allHits"/>
 *             &lt;enumeration value="bestHits"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="wordSeparatorCharacterRE" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "textIndexNormalizations",
    "expression"
})
@XmlRootElement(name = "TextIndex")
@Added(Version.PMML_4_2)
public class TextIndex
    extends org.dmg.pmml.Expression
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "TextIndexNormalization")
    protected List<TextIndexNormalization> textIndexNormalizations;
    @XmlElements({
        @XmlElement(name = "Constant", type = Constant.class),
        @XmlElement(name = "FieldRef", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", type = Discretize.class),
        @XmlElement(name = "MapValues", type = MapValues.class),
        @XmlElement(name = "TextIndex", type = TextIndex.class),
        @XmlElement(name = "Apply", type = Apply.class),
        @XmlElement(name = "Aggregate", type = Aggregate.class)
    })
    protected org.dmg.pmml.Expression expression;
    @XmlAttribute(name = "textField", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    protected FieldName textField;
    @XmlAttribute(name = "localTermWeights")
    protected String localTermWeights;
    @XmlAttribute(name = "isCaseSensitive")
    protected String isCaseSensitive;
    @XmlAttribute(name = "maxLevenshteinDistance")
    protected Integer maxLevenshteinDistance;
    @XmlAttribute(name = "countHits")
    protected String countHits;
    @XmlAttribute(name = "wordSeparatorCharacterRE")
    protected String wordSeparatorCharacterRE;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public TextIndex() {
        super();
    }

    public TextIndex(final FieldName textField) {
        super();
        this.textField = textField;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the textIndexNormalizations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the textIndexNormalizations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTextIndexNormalizations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextIndexNormalization }
     * 
     * 
     */
    public List<TextIndexNormalization> getTextIndexNormalizations() {
        if (textIndexNormalizations == null) {
            textIndexNormalizations = new ArrayList<TextIndexNormalization>();
        }
        return this.textIndexNormalizations;
    }

    /**
     * Gets the value of the expression property.
     * 
     * @return
     *     possible object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link TextIndex }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public org.dmg.pmml.Expression getExpression() {
        return expression;
    }

    /**
     * Sets the value of the expression property.
     * 
     * @param value
     *     allowed object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link TextIndex }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public void setExpression(org.dmg.pmml.Expression value) {
        this.expression = value;
    }

    /**
     * Gets the value of the textField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTextField() {
        return textField;
    }

    /**
     * Sets the value of the textField property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTextField(FieldName value) {
        this.textField = value;
    }

    /**
     * Gets the value of the localTermWeights property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLocalTermWeights() {
        if (localTermWeights == null) {
            return "termFrequency";
        } else {
            return localTermWeights;
        }
    }

    /**
     * Sets the value of the localTermWeights property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLocalTermWeights(String value) {
        this.localTermWeights = value;
    }

    /**
     * Gets the value of the isCaseSensitive property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIsCaseSensitive() {
        if (isCaseSensitive == null) {
            return "false";
        } else {
            return isCaseSensitive;
        }
    }

    /**
     * Sets the value of the isCaseSensitive property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIsCaseSensitive(String value) {
        this.isCaseSensitive = value;
    }

    /**
     * Gets the value of the maxLevenshteinDistance property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMaxLevenshteinDistance() {
        if (maxLevenshteinDistance == null) {
            return  0;
        } else {
            return maxLevenshteinDistance;
        }
    }

    /**
     * Sets the value of the maxLevenshteinDistance property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setMaxLevenshteinDistance(Integer value) {
        this.maxLevenshteinDistance = value;
    }

    /**
     * Gets the value of the countHits property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCountHits() {
        if (countHits == null) {
            return "allHits";
        } else {
            return countHits;
        }
    }

    /**
     * Sets the value of the countHits property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCountHits(String value) {
        this.countHits = value;
    }

    /**
     * Gets the value of the wordSeparatorCharacterRE property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getWordSeparatorCharacterRE() {
        return wordSeparatorCharacterRE;
    }

    /**
     * Sets the value of the wordSeparatorCharacterRE property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setWordSeparatorCharacterRE(String value) {
        this.wordSeparatorCharacterRE = value;
    }

    public TextIndex withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public TextIndex withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public TextIndex withTextIndexNormalizations(TextIndexNormalization... values) {
        if (values!= null) {
            for (TextIndexNormalization value: values) {
                getTextIndexNormalizations().add(value);
            }
        }
        return this;
    }

    public TextIndex withTextIndexNormalizations(Collection<TextIndexNormalization> values) {
        if (values!= null) {
            getTextIndexNormalizations().addAll(values);
        }
        return this;
    }

    public TextIndex withExpression(org.dmg.pmml.Expression value) {
        setExpression(value);
        return this;
    }

    public TextIndex withTextField(FieldName value) {
        setTextField(value);
        return this;
    }

    public TextIndex withLocalTermWeights(String value) {
        setLocalTermWeights(value);
        return this;
    }

    public TextIndex withIsCaseSensitive(String value) {
        setIsCaseSensitive(value);
        return this;
    }

    public TextIndex withMaxLevenshteinDistance(Integer value) {
        setMaxLevenshteinDistance(value);
        return this;
    }

    public TextIndex withCountHits(String value) {
        setCountHits(value);
        return this;
    }

    public TextIndex withWordSeparatorCharacterRE(String value) {
        setWordSeparatorCharacterRE(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.textIndexNormalizations!= null))&&(i<this.textIndexNormalizations.size())); i ++) {
            status = this.textIndexNormalizations.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.expression!= null)) {
            status = this.expression.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
