
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for TIMESERIES-ALGORITHM.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="TIMESERIES-ALGORITHM">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="ARIMA"/>
 *     &lt;enumeration value="ExponentialSmoothing"/>
 *     &lt;enumeration value="SeasonalTrendDecomposition"/>
 *     &lt;enumeration value="SpectralAnalysis"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "TIMESERIES-ALGORITHM")
@XmlEnum
@Added(Version.PMML_4_0)
public enum TimeSeriesAlgorithmType {

    ARIMA("ARIMA"),
    @XmlEnumValue("ExponentialSmoothing")
    EXPONENTIAL_SMOOTHING("ExponentialSmoothing"),
    @XmlEnumValue("SeasonalTrendDecomposition")
    SEASONAL_TREND_DECOMPOSITION("SeasonalTrendDecomposition"),
    @XmlEnumValue("SpectralAnalysis")
    SPECTRAL_ANALYSIS("SpectralAnalysis");
    private final String value;

    TimeSeriesAlgorithmType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TimeSeriesAlgorithmType fromValue(String v) {
        for (TimeSeriesAlgorithmType c: TimeSeriesAlgorithmType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
