
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for TIMESERIES-USAGE.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="TIMESERIES-USAGE">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="original"/>
 *     &lt;enumeration value="logical"/>
 *     &lt;enumeration value="prediction"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "TIMESERIES-USAGE")
@XmlEnum
@Added(Version.PMML_4_0)
public enum TimeSeriesUsageType {

    @XmlEnumValue("original")
    ORIGINAL("original"),
    @XmlEnumValue("logical")
    LOGICAL("logical"),
    @XmlEnumValue("prediction")
    PREDICTION("prediction");
    private final String value;

    TimeSeriesUsageType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TimeSeriesUsageType fromValue(String v) {
        for (TimeSeriesUsageType c: TimeSeriesUsageType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
