/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import org.jpmml.schema.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class PMMLFilter
extends XMLFilterImpl {
    private Version source = null;
    private Version target = null;

    public PMMLFilter(Version target) {
        this.setTarget(target);
    }

    public PMMLFilter(XMLReader reader, Version target) {
        super(reader);
        this.setTarget(target);
    }

    public abstract String filterLocalName(String var1);

    public abstract Attributes filterAttributes(String var1, Attributes var2);

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        if ("".equals(prefix)) {
            this.updateSource(namespaceURI);
            super.startPrefixMapping("", this.getNamespaceURI());
            return;
        }
        super.startPrefixMapping(prefix, namespaceURI);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        this.updateSource(namespaceURI);
        String filteredNamespaceURI = this.getNamespaceURI();
        String filteredLocalName = this.filterLocalName(localName);
        String filteredQualifiedName = PMMLFilter.formatQualifiedName(qualifiedName, filteredNamespaceURI, filteredLocalName);
        Attributes filteredAttributes = this.filterAttributes(localName, attributes);
        super.startElement(filteredNamespaceURI, filteredLocalName, filteredQualifiedName, filteredAttributes);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        String filteredNamespaceURI = this.getNamespaceURI();
        String filteredLocalName = this.filterLocalName(localName);
        String filteredQualifiedName = PMMLFilter.formatQualifiedName(qualifiedName, filteredNamespaceURI, filteredLocalName);
        super.endElement(filteredNamespaceURI, filteredLocalName, filteredQualifiedName);
    }

    private String getNamespaceURI() {
        Version target = this.getTarget();
        return target.getNamespaceURI();
    }

    private void updateSource(String namespaceURI) {
        if ("".equals(namespaceURI)) {
            return;
        }
        Version version = Version.forNamespaceURI((String)namespaceURI);
        Version source = this.getSource();
        if (source != null && !source.equals((Object)version)) {
            throw new IllegalStateException();
        }
        this.setSource(version);
    }

    public Version getSource() {
        return this.source;
    }

    private void setSource(Version source) {
        this.source = source;
    }

    public Version getTarget() {
        return this.target;
    }

    private void setTarget(Version target) {
        this.target = target;
    }

    protected static int compare(Version left, Version right) {
        if (left == null || right == null) {
            throw new IllegalStateException();
        }
        return left.compareTo((Enum)right);
    }

    private static String formatQualifiedName(String template, String namespaceURI, String localName) {
        if ("".equals(template)) {
            return "";
        }
        if (template.indexOf(58) > -1) {
            return namespaceURI + ":" + localName;
        }
        return localName;
    }

    protected static boolean hasAttribute(Attributes attributes, String localName) {
        int index = attributes.getIndex("", localName);
        return index > -1;
    }

    protected static Attributes renameAttribute(Attributes attributes, String oldLocalName, String localName) {
        int index = attributes.getIndex("", oldLocalName);
        if (index < 0) {
            return attributes;
        }
        AttributesImpl result = new AttributesImpl(attributes);
        result.setLocalName(index, localName);
        result.setQName(index, localName);
        return result;
    }
}

