
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LinearNorm" maxOccurs="unbounded" minOccurs="2"/>
 *       &lt;/sequence>
 *       &lt;attribute name="mapMissingTo" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="outliers" type="{http://www.dmg.org/PMML-4_2}OUTLIER-TREATMENT-METHOD" default="asIs" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "linearNorms"
})
@XmlRootElement(name = "NormContinuous")
public class NormContinuous
    extends Expression
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "LinearNorm", required = true)
    protected List<LinearNorm> linearNorms;
    @XmlAttribute(name = "mapMissingTo")
    @Added(Version.PMML_3_2)
    protected Double mapMissingTo;
    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    protected FieldName field;
    @XmlAttribute(name = "outliers")
    @Added(Version.PMML_3_2)
    protected OutlierTreatmentMethodType outliers;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public NormContinuous() {
        super();
    }

    public NormContinuous(final FieldName field) {
        super();
        this.field = field;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the linearNorms property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the linearNorms property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLinearNorms().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LinearNorm }
     * 
     * 
     */
    public List<LinearNorm> getLinearNorms() {
        if (linearNorms == null) {
            linearNorms = new ArrayList<LinearNorm>();
        }
        return this.linearNorms;
    }

    /**
     * Gets the value of the mapMissingTo property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMapMissingTo() {
        return mapMissingTo;
    }

    /**
     * Sets the value of the mapMissingTo property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMapMissingTo(Double value) {
        this.mapMissingTo = value;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setField(FieldName value) {
        this.field = value;
    }

    /**
     * Gets the value of the outliers property.
     * 
     * @return
     *     possible object is
     *     {@link OutlierTreatmentMethodType }
     *     
     */
    public OutlierTreatmentMethodType getOutliers() {
        if (outliers == null) {
            return OutlierTreatmentMethodType.AS_IS;
        } else {
            return outliers;
        }
    }

    /**
     * Sets the value of the outliers property.
     * 
     * @param value
     *     allowed object is
     *     {@link OutlierTreatmentMethodType }
     *     
     */
    public void setOutliers(OutlierTreatmentMethodType value) {
        this.outliers = value;
    }

    public NormContinuous withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public NormContinuous withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public NormContinuous withLinearNorms(LinearNorm... values) {
        if (values!= null) {
            for (LinearNorm value: values) {
                getLinearNorms().add(value);
            }
        }
        return this;
    }

    public NormContinuous withLinearNorms(Collection<LinearNorm> values) {
        if (values!= null) {
            getLinearNorms().addAll(values);
        }
        return this;
    }

    public NormContinuous withMapMissingTo(Double value) {
        setMapMissingTo(value);
        return this;
    }

    public NormContinuous withField(FieldName value) {
        setField(value);
        return this;
    }

    public NormContinuous withOutliers(OutlierTreatmentMethodType value) {
        setOutliers(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.linearNorms!= null))&&(i<this.linearNorms.size())); i ++) {
            status = this.linearNorms.get(i).accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
