
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;sequence>
 *           &lt;choice>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}LinearKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}PolynomialKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}RadialBasisKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}SigmoidKernelType"/>
 *           &lt;/choice>
 *         &lt;/sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}VectorDictionary"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}SupportVectorMachine" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="alternateBinaryTargetCategory" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *       &lt;attribute name="svmRepresentation" type="{http://www.dmg.org/PMML-4_2}SVM-REPRESENTATION" default="SupportVectors" />
 *       &lt;attribute name="classificationMethod" type="{http://www.dmg.org/PMML-4_2}SVM-CLASSIFICATION-METHOD" default="OneAgainstAll" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "kernelType",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
@XmlRootElement(name = "SupportVectorMachineModel")
public class SupportVectorMachineModel
    extends Model
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    @Added(Version.PMML_4_0)
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElements({
        @XmlElement(name = "LinearKernelType", type = LinearKernelType.class),
        @XmlElement(name = "PolynomialKernelType", type = PolynomialKernelType.class),
        @XmlElement(name = "RadialBasisKernelType", type = RadialBasisKernelType.class),
        @XmlElement(name = "SigmoidKernelType", type = SigmoidKernelType.class)
    })
    protected KernelType kernelType;
    @XmlElement(name = "VectorDictionary", required = true)
    protected VectorDictionary vectorDictionary;
    @XmlElement(name = "SupportVectorMachine", required = true)
    protected List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "alternateBinaryTargetCategory")
    @Removed(Version.PMML_4_0)
    protected String alternateBinaryTargetCategory;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "threshold")
    @Added(Version.PMML_4_0)
    protected Double threshold;
    @XmlAttribute(name = "svmRepresentation")
    protected SvmRepresentationType svmRepresentation;
    @XmlAttribute(name = "classificationMethod")
    @Added(Version.PMML_4_0)
    protected SvmClassificationMethodType classificationMethod;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    protected Boolean scorable;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public SupportVectorMachineModel() {
        super();
    }

    public SupportVectorMachineModel(final MiningSchema miningSchema, final VectorDictionary vectorDictionary, final MiningFunctionType functionName) {
        super();
        this.miningSchema = miningSchema;
        this.vectorDictionary = vectorDictionary;
        this.functionName = functionName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the kernelType property.
     * 
     * @return
     *     possible object is
     *     {@link LinearKernelType }
     *     {@link PolynomialKernelType }
     *     {@link RadialBasisKernelType }
     *     {@link SigmoidKernelType }
     *     
     */
    public KernelType getKernelType() {
        return kernelType;
    }

    /**
     * Sets the value of the kernelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link LinearKernelType }
     *     {@link PolynomialKernelType }
     *     {@link RadialBasisKernelType }
     *     {@link SigmoidKernelType }
     *     
     */
    public void setKernelType(KernelType value) {
        this.kernelType = value;
    }

    /**
     * Gets the value of the vectorDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link VectorDictionary }
     *     
     */
    public VectorDictionary getVectorDictionary() {
        return vectorDictionary;
    }

    /**
     * Sets the value of the vectorDictionary property.
     * 
     * @param value
     *     allowed object is
     *     {@link VectorDictionary }
     *     
     */
    public void setVectorDictionary(VectorDictionary value) {
        this.vectorDictionary = value;
    }

    /**
     * Gets the value of the supportVectorMachines property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportVectorMachines property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportVectorMachines().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupportVectorMachine }
     * 
     * 
     */
    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (supportVectorMachines == null) {
            supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the alternateBinaryTargetCategory property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlternateBinaryTargetCategory() {
        return alternateBinaryTargetCategory;
    }

    /**
     * Sets the value of the alternateBinaryTargetCategory property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlternateBinaryTargetCategory(String value) {
        this.alternateBinaryTargetCategory = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getThreshold() {
        if (threshold == null) {
            return  0.0D;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setThreshold(Double value) {
        this.threshold = value;
    }

    /**
     * Gets the value of the svmRepresentation property.
     * 
     * @return
     *     possible object is
     *     {@link SvmRepresentationType }
     *     
     */
    public SvmRepresentationType getSvmRepresentation() {
        if (svmRepresentation == null) {
            return SvmRepresentationType.SUPPORT_VECTORS;
        } else {
            return svmRepresentation;
        }
    }

    /**
     * Sets the value of the svmRepresentation property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvmRepresentationType }
     *     
     */
    public void setSvmRepresentation(SvmRepresentationType value) {
        this.svmRepresentation = value;
    }

    /**
     * Gets the value of the classificationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link SvmClassificationMethodType }
     *     
     */
    public SvmClassificationMethodType getClassificationMethod() {
        if (classificationMethod == null) {
            return SvmClassificationMethodType.ONE_AGAINST_ALL;
        } else {
            return classificationMethod;
        }
    }

    /**
     * Sets the value of the classificationMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvmClassificationMethodType }
     *     
     */
    public void setClassificationMethod(SvmClassificationMethodType value) {
        this.classificationMethod = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public SupportVectorMachineModel withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public SupportVectorMachineModel withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public SupportVectorMachineModel withMiningSchema(MiningSchema value) {
        setMiningSchema(value);
        return this;
    }

    public SupportVectorMachineModel withOutput(Output value) {
        setOutput(value);
        return this;
    }

    public SupportVectorMachineModel withModelStats(ModelStats value) {
        setModelStats(value);
        return this;
    }

    public SupportVectorMachineModel withModelExplanation(ModelExplanation value) {
        setModelExplanation(value);
        return this;
    }

    public SupportVectorMachineModel withTargets(Targets value) {
        setTargets(value);
        return this;
    }

    public SupportVectorMachineModel withLocalTransformations(LocalTransformations value) {
        setLocalTransformations(value);
        return this;
    }

    public SupportVectorMachineModel withKernelType(KernelType value) {
        setKernelType(value);
        return this;
    }

    public SupportVectorMachineModel withVectorDictionary(VectorDictionary value) {
        setVectorDictionary(value);
        return this;
    }

    public SupportVectorMachineModel withSupportVectorMachines(SupportVectorMachine... values) {
        if (values!= null) {
            for (SupportVectorMachine value: values) {
                getSupportVectorMachines().add(value);
            }
        }
        return this;
    }

    public SupportVectorMachineModel withSupportVectorMachines(Collection<SupportVectorMachine> values) {
        if (values!= null) {
            getSupportVectorMachines().addAll(values);
        }
        return this;
    }

    public SupportVectorMachineModel withModelVerification(ModelVerification value) {
        setModelVerification(value);
        return this;
    }

    public SupportVectorMachineModel withModelName(String value) {
        setModelName(value);
        return this;
    }

    public SupportVectorMachineModel withAlternateBinaryTargetCategory(String value) {
        setAlternateBinaryTargetCategory(value);
        return this;
    }

    public SupportVectorMachineModel withFunctionName(MiningFunctionType value) {
        setFunctionName(value);
        return this;
    }

    public SupportVectorMachineModel withAlgorithmName(String value) {
        setAlgorithmName(value);
        return this;
    }

    public SupportVectorMachineModel withThreshold(Double value) {
        setThreshold(value);
        return this;
    }

    public SupportVectorMachineModel withSvmRepresentation(SvmRepresentationType value) {
        setSvmRepresentation(value);
        return this;
    }

    public SupportVectorMachineModel withClassificationMethod(SvmClassificationMethodType value) {
        setClassificationMethod(value);
        return this;
    }

    public SupportVectorMachineModel withScorable(Boolean value) {
        setScorable(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.miningSchema!= null)) {
            status = this.miningSchema.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.output!= null)) {
            status = this.output.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelStats!= null)) {
            status = this.modelStats.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelExplanation!= null)) {
            status = this.modelExplanation.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.targets!= null)) {
            status = this.targets.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.localTransformations!= null)) {
            status = this.localTransformations.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.kernelType!= null)) {
            status = this.kernelType.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.vectorDictionary!= null)) {
            status = this.vectorDictionary.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.supportVectorMachines!= null))&&(i<this.supportVectorMachines.size())); i ++) {
            status = this.supportVectorMachines.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelVerification!= null)) {
            status = this.modelVerification.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
