
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelLiftGraph"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}OptimumLiftGraph" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}RandomLiftGraph" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="targetFieldValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="targetFieldDisplayValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="rankingQuality" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "modelLiftGraph",
    "optimumLiftGraph",
    "randomLiftGraph"
})
@XmlRootElement(name = "LiftData", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class LiftData
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "ModelLiftGraph", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected ModelLiftGraph modelLiftGraph;
    @XmlElement(name = "OptimumLiftGraph", namespace = "http://www.dmg.org/PMML-4_2")
    protected OptimumLiftGraph optimumLiftGraph;
    @XmlElement(name = "RandomLiftGraph", namespace = "http://www.dmg.org/PMML-4_2")
    protected RandomLiftGraph randomLiftGraph;
    @XmlAttribute(name = "targetFieldValue")
    protected String targetFieldValue;
    @XmlAttribute(name = "targetFieldDisplayValue")
    protected String targetFieldDisplayValue;
    @XmlAttribute(name = "rankingQuality")
    protected Double rankingQuality;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public LiftData() {
        super();
    }

    public LiftData(final ModelLiftGraph modelLiftGraph) {
        super();
        this.modelLiftGraph = modelLiftGraph;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the modelLiftGraph property.
     * 
     * @return
     *     possible object is
     *     {@link ModelLiftGraph }
     *     
     */
    public ModelLiftGraph getModelLiftGraph() {
        return modelLiftGraph;
    }

    /**
     * Sets the value of the modelLiftGraph property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelLiftGraph }
     *     
     */
    public void setModelLiftGraph(ModelLiftGraph value) {
        this.modelLiftGraph = value;
    }

    /**
     * Gets the value of the optimumLiftGraph property.
     * 
     * @return
     *     possible object is
     *     {@link OptimumLiftGraph }
     *     
     */
    public OptimumLiftGraph getOptimumLiftGraph() {
        return optimumLiftGraph;
    }

    /**
     * Sets the value of the optimumLiftGraph property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimumLiftGraph }
     *     
     */
    public void setOptimumLiftGraph(OptimumLiftGraph value) {
        this.optimumLiftGraph = value;
    }

    /**
     * Gets the value of the randomLiftGraph property.
     * 
     * @return
     *     possible object is
     *     {@link RandomLiftGraph }
     *     
     */
    public RandomLiftGraph getRandomLiftGraph() {
        return randomLiftGraph;
    }

    /**
     * Sets the value of the randomLiftGraph property.
     * 
     * @param value
     *     allowed object is
     *     {@link RandomLiftGraph }
     *     
     */
    public void setRandomLiftGraph(RandomLiftGraph value) {
        this.randomLiftGraph = value;
    }

    /**
     * Gets the value of the targetFieldValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetFieldValue() {
        return targetFieldValue;
    }

    /**
     * Sets the value of the targetFieldValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetFieldValue(String value) {
        this.targetFieldValue = value;
    }

    /**
     * Gets the value of the targetFieldDisplayValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetFieldDisplayValue() {
        return targetFieldDisplayValue;
    }

    /**
     * Sets the value of the targetFieldDisplayValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetFieldDisplayValue(String value) {
        this.targetFieldDisplayValue = value;
    }

    /**
     * Gets the value of the rankingQuality property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRankingQuality() {
        return rankingQuality;
    }

    /**
     * Sets the value of the rankingQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setRankingQuality(Double value) {
        this.rankingQuality = value;
    }

    public LiftData withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public LiftData withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public LiftData withModelLiftGraph(ModelLiftGraph value) {
        setModelLiftGraph(value);
        return this;
    }

    public LiftData withOptimumLiftGraph(OptimumLiftGraph value) {
        setOptimumLiftGraph(value);
        return this;
    }

    public LiftData withRandomLiftGraph(RandomLiftGraph value) {
        setRandomLiftGraph(value);
        return this;
    }

    public LiftData withTargetFieldValue(String value) {
        setTargetFieldValue(value);
        return this;
    }

    public LiftData withTargetFieldDisplayValue(String value) {
        setTargetFieldDisplayValue(value);
        return this;
    }

    public LiftData withRankingQuality(Double value) {
        setRankingQuality(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelLiftGraph!= null)) {
            status = this.modelLiftGraph.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.optimumLiftGraph!= null)) {
            status = this.optimumLiftGraph.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.randomLiftGraph!= null)) {
            status = this.randomLiftGraph.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
