
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}InstanceFields"/>
 *         &lt;choice>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}TableLocator"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}InlineTable"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="isTransformed" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="recordCount" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="fieldCount" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "instanceFields",
    "tableLocator",
    "inlineTable"
})
@XmlRootElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_1)
public class TrainingInstances
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "InstanceFields", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected InstanceFields instanceFields;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_2")
    protected TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_2")
    protected InlineTable inlineTable;
    @XmlAttribute(name = "isTransformed")
    protected Boolean transformed;
    @XmlAttribute(name = "recordCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer recordCount;
    @XmlAttribute(name = "fieldCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer fieldCount;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public TrainingInstances() {
        super();
    }

    public TrainingInstances(final InstanceFields instanceFields) {
        super();
        this.instanceFields = instanceFields;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the instanceFields property.
     * 
     * @return
     *     possible object is
     *     {@link InstanceFields }
     *     
     */
    public InstanceFields getInstanceFields() {
        return instanceFields;
    }

    /**
     * Sets the value of the instanceFields property.
     * 
     * @param value
     *     allowed object is
     *     {@link InstanceFields }
     *     
     */
    public void setInstanceFields(InstanceFields value) {
        this.instanceFields = value;
    }

    /**
     * Gets the value of the tableLocator property.
     * 
     * @return
     *     possible object is
     *     {@link TableLocator }
     *     
     */
    public TableLocator getTableLocator() {
        return tableLocator;
    }

    /**
     * Sets the value of the tableLocator property.
     * 
     * @param value
     *     allowed object is
     *     {@link TableLocator }
     *     
     */
    public void setTableLocator(TableLocator value) {
        this.tableLocator = value;
    }

    /**
     * Gets the value of the inlineTable property.
     * 
     * @return
     *     possible object is
     *     {@link InlineTable }
     *     
     */
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    /**
     * Sets the value of the inlineTable property.
     * 
     * @param value
     *     allowed object is
     *     {@link InlineTable }
     *     
     */
    public void setInlineTable(InlineTable value) {
        this.inlineTable = value;
    }

    /**
     * Gets the value of the transformed property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isTransformed() {
        if (transformed == null) {
            return false;
        } else {
            return transformed;
        }
    }

    /**
     * Sets the value of the transformed property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setTransformed(Boolean value) {
        this.transformed = value;
    }

    /**
     * Gets the value of the recordCount property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getRecordCount() {
        return recordCount;
    }

    /**
     * Sets the value of the recordCount property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRecordCount(Integer value) {
        this.recordCount = value;
    }

    /**
     * Gets the value of the fieldCount property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getFieldCount() {
        return fieldCount;
    }

    /**
     * Sets the value of the fieldCount property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFieldCount(Integer value) {
        this.fieldCount = value;
    }

    public TrainingInstances withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public TrainingInstances withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public TrainingInstances withInstanceFields(InstanceFields value) {
        setInstanceFields(value);
        return this;
    }

    public TrainingInstances withTableLocator(TableLocator value) {
        setTableLocator(value);
        return this;
    }

    public TrainingInstances withInlineTable(InlineTable value) {
        setInlineTable(value);
        return this;
    }

    public TrainingInstances withTransformed(Boolean value) {
        setTransformed(value);
        return this;
    }

    public TrainingInstances withRecordCount(Integer value) {
        setRecordCount(value);
        return this;
    }

    public TrainingInstances withFieldCount(Integer value) {
        setFieldCount(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.instanceFields!= null)) {
            status = this.instanceFields.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.tableLocator!= null)) {
            status = this.tableLocator.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.inlineTable!= null)) {
            status = this.inlineTable.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
