/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.math.BigDecimal;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.dmg.pmml.ValueUtil;

public class DecimalAdapter
extends XmlAdapter<String, Double> {
    private static final BigDecimal MIN = BigDecimal.valueOf(Double.MIN_VALUE);
    private static final BigDecimal MAX = BigDecimal.valueOf(Double.MAX_VALUE);

    public Double unmarshal(String value) {
        BigDecimal decimal = DatatypeConverter.parseDecimal((String)value);
        if (!ValueUtil.checkRange(decimal, MIN, MAX)) {
            throw new IllegalArgumentException(value);
        }
        return decimal.doubleValue();
    }

    public String marshal(Double value) {
        if (value == null) {
            return null;
        }
        return DatatypeConverter.printDouble((double)value);
    }
}

