
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Comparisons" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="isCenterField" default="true">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="true"/>
 *             &lt;enumeration value="false"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="fieldWeight" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="1" />
 *       &lt;attribute name="similarityScale" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="compareFunction" type="{http://www.dmg.org/PMML-4_2}COMPARE-FUNCTION" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "comparisons"
})
@XmlRootElement(name = "ClusteringField", namespace = "http://www.dmg.org/PMML-4_2")
public class ClusteringField
    extends ComparisonField
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "Comparisons", namespace = "http://www.dmg.org/PMML-4_2")
    protected Comparisons comparisons;
    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    protected FieldName field;
    @XmlAttribute(name = "isCenterField")
    @Added(Version.PMML_3_2)
    protected ClusteringField.CenterField centerField;
    @XmlAttribute(name = "fieldWeight")
    protected Double fieldWeight;
    @XmlAttribute(name = "similarityScale")
    protected Double similarityScale;
    @XmlAttribute(name = "compareFunction")
    protected CompareFunctionType compareFunction;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public ClusteringField() {
        super();
    }

    public ClusteringField(final FieldName field) {
        super();
        this.field = field;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the comparisons property.
     * 
     * @return
     *     possible object is
     *     {@link Comparisons }
     *     
     */
    public Comparisons getComparisons() {
        return comparisons;
    }

    /**
     * Sets the value of the comparisons property.
     * 
     * @param value
     *     allowed object is
     *     {@link Comparisons }
     *     
     */
    public void setComparisons(Comparisons value) {
        this.comparisons = value;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setField(FieldName value) {
        this.field = value;
    }

    /**
     * Gets the value of the centerField property.
     * 
     * @return
     *     possible object is
     *     {@link ClusteringField.CenterField }
     *     
     */
    public ClusteringField.CenterField getCenterField() {
        if (centerField == null) {
            return ClusteringField.CenterField.TRUE;
        } else {
            return centerField;
        }
    }

    /**
     * Sets the value of the centerField property.
     * 
     * @param value
     *     allowed object is
     *     {@link ClusteringField.CenterField }
     *     
     */
    public void setCenterField(ClusteringField.CenterField value) {
        this.centerField = value;
    }

    /**
     * Gets the value of the fieldWeight property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getFieldWeight() {
        if (fieldWeight == null) {
            return  1.0D;
        } else {
            return fieldWeight;
        }
    }

    /**
     * Sets the value of the fieldWeight property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setFieldWeight(Double value) {
        this.fieldWeight = value;
    }

    /**
     * Gets the value of the similarityScale property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getSimilarityScale() {
        return similarityScale;
    }

    /**
     * Sets the value of the similarityScale property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setSimilarityScale(Double value) {
        this.similarityScale = value;
    }

    /**
     * Gets the value of the compareFunction property.
     * 
     * @return
     *     possible object is
     *     {@link CompareFunctionType }
     *     
     */
    public CompareFunctionType getCompareFunction() {
        return compareFunction;
    }

    /**
     * Sets the value of the compareFunction property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompareFunctionType }
     *     
     */
    public void setCompareFunction(CompareFunctionType value) {
        this.compareFunction = value;
    }

    public ClusteringField withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public ClusteringField withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public ClusteringField withComparisons(Comparisons value) {
        setComparisons(value);
        return this;
    }

    public ClusteringField withField(FieldName value) {
        setField(value);
        return this;
    }

    public ClusteringField withCenterField(ClusteringField.CenterField value) {
        setCenterField(value);
        return this;
    }

    public ClusteringField withFieldWeight(Double value) {
        setFieldWeight(value);
        return this;
    }

    public ClusteringField withSimilarityScale(Double value) {
        setSimilarityScale(value);
        return this;
    }

    public ClusteringField withCompareFunction(CompareFunctionType value) {
        setCompareFunction(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.comparisons!= null)) {
            status = this.comparisons.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="true"/>
     *     &lt;enumeration value="false"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_3_2)
    public enum CenterField {

        @XmlEnumValue("true")
        TRUE("true"),
        @XmlEnumValue("false")
        FALSE("false");
        private final String value;

        CenterField(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ClusteringField.CenterField fromValue(String v) {
            for (ClusteringField.CenterField c: ClusteringField.CenterField.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
