
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}VectorFields"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}VectorInstance" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfVectors" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "vectorFields",
    "vectorInstances"
})
@XmlRootElement(name = "VectorDictionary", namespace = "http://www.dmg.org/PMML-4_2")
public class VectorDictionary
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "VectorFields", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    @Added(Version.PMML_3_1)
    protected VectorFields vectorFields;
    @XmlElement(name = "VectorInstance", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<VectorInstance> vectorInstances;
    @XmlAttribute(name = "numberOfVectors")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer numberOfVectors;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public VectorDictionary() {
        super();
    }

    public VectorDictionary(final VectorFields vectorFields) {
        super();
        this.vectorFields = vectorFields;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the vectorFields property.
     * 
     * @return
     *     possible object is
     *     {@link VectorFields }
     *     
     */
    public VectorFields getVectorFields() {
        return vectorFields;
    }

    /**
     * Sets the value of the vectorFields property.
     * 
     * @param value
     *     allowed object is
     *     {@link VectorFields }
     *     
     */
    public void setVectorFields(VectorFields value) {
        this.vectorFields = value;
    }

    /**
     * Gets the value of the vectorInstances property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the vectorInstances property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getVectorInstances().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VectorInstance }
     * 
     * 
     */
    public List<VectorInstance> getVectorInstances() {
        if (vectorInstances == null) {
            vectorInstances = new ArrayList<VectorInstance>();
        }
        return this.vectorInstances;
    }

    /**
     * Gets the value of the numberOfVectors property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfVectors() {
        return numberOfVectors;
    }

    /**
     * Sets the value of the numberOfVectors property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNumberOfVectors(Integer value) {
        this.numberOfVectors = value;
    }

    public VectorDictionary withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public VectorDictionary withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public VectorDictionary withVectorFields(VectorFields value) {
        setVectorFields(value);
        return this;
    }

    public VectorDictionary withVectorInstances(VectorInstance... values) {
        if (values!= null) {
            for (VectorInstance value: values) {
                getVectorInstances().add(value);
            }
        }
        return this;
    }

    public VectorDictionary withVectorInstances(Collection<VectorInstance> values) {
        if (values!= null) {
            getVectorInstances().addAll(values);
        }
        return this;
    }

    public VectorDictionary withNumberOfVectors(Integer value) {
        setNumberOfVectors(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.vectorFields!= null)) {
            status = this.vectorFields.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.vectorInstances!= null))&&(i<this.vectorInstances.size())); i ++) {
            status = this.vectorInstances.get(i).accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
