
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}CorrelationFields"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}CorrelationValues"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}CorrelationMethods" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "correlationFields",
    "correlationValues",
    "correlationMethods"
})
@XmlRootElement(name = "Correlations", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class Correlations
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "CorrelationFields", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private CorrelationFields correlationFields;
    @XmlElement(name = "CorrelationValues", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private CorrelationValues correlationValues;
    @XmlElement(name = "CorrelationMethods", namespace = "http://www.dmg.org/PMML-4_2")
    private CorrelationMethods correlationMethods;

    public Correlations() {
        super();
    }

    public Correlations(final CorrelationFields correlationFields, final CorrelationValues correlationValues) {
        super();
        this.correlationFields = correlationFields;
        this.correlationValues = correlationValues;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the correlationFields property.
     * 
     * @return
     *     possible object is
     *     {@link CorrelationFields }
     *     
     */
    public CorrelationFields getCorrelationFields() {
        return correlationFields;
    }

    /**
     * Sets the value of the correlationFields property.
     * 
     * @param value
     *     allowed object is
     *     {@link CorrelationFields }
     *     
     */
    public Correlations setCorrelationFields(CorrelationFields correlationFields) {
        this.correlationFields = correlationFields;
        return this;
    }

    /**
     * Gets the value of the correlationValues property.
     * 
     * @return
     *     possible object is
     *     {@link CorrelationValues }
     *     
     */
    public CorrelationValues getCorrelationValues() {
        return correlationValues;
    }

    /**
     * Sets the value of the correlationValues property.
     * 
     * @param value
     *     allowed object is
     *     {@link CorrelationValues }
     *     
     */
    public Correlations setCorrelationValues(CorrelationValues correlationValues) {
        this.correlationValues = correlationValues;
        return this;
    }

    /**
     * Gets the value of the correlationMethods property.
     * 
     * @return
     *     possible object is
     *     {@link CorrelationMethods }
     *     
     */
    public CorrelationMethods getCorrelationMethods() {
        return correlationMethods;
    }

    /**
     * Sets the value of the correlationMethods property.
     * 
     * @param value
     *     allowed object is
     *     {@link CorrelationMethods }
     *     
     */
    public Correlations setCorrelationMethods(CorrelationMethods correlationMethods) {
        this.correlationMethods = correlationMethods;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Correlations addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
        }
        CorrelationFields correlationFields = getCorrelationFields();
        if ((status == VisitorAction.CONTINUE)&&(correlationFields!= null)) {
            status = correlationFields.accept(visitor);
        }
        CorrelationValues correlationValues = getCorrelationValues();
        if ((status == VisitorAction.CONTINUE)&&(correlationValues!= null)) {
            status = correlationValues.accept(visitor);
        }
        CorrelationMethods correlationMethods = getCorrelationMethods();
        if ((status == VisitorAction.CONTINUE)&&(correlationMethods!= null)) {
            status = correlationMethods.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
