
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;choice minOccurs="0">
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}NUM-ARRAY" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MatCell" maxOccurs="unbounded"/>
 *       &lt;/choice>
 *       &lt;attribute name="kind" default="any">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="diagonal"/>
 *             &lt;enumeration value="symmetric"/>
 *             &lt;enumeration value="any"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="nbRows" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="nbCols" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="diagDefault" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="offDiagDefault" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "arrays",
    "matCells"
})
@XmlRootElement(name = "Matrix", namespace = "http://www.dmg.org/PMML-4_2")
public class Matrix
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "kind")
    private Matrix.Kind kind;
    @XmlAttribute(name = "nbRows")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer nbRows;
    @XmlAttribute(name = "nbCols")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer nbCols;
    @XmlAttribute(name = "diagDefault")
    private Double diagDefault;
    @XmlAttribute(name = "offDiagDefault")
    private Double offDiagDefault;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Array> arrays;
    @XmlElement(name = "MatCell", namespace = "http://www.dmg.org/PMML-4_2")
    private List<MatCell> matCells;

    /**
     * Gets the value of the kind property.
     * 
     * @return
     *     possible object is
     *     {@link Matrix.Kind }
     *     
     */
    public Matrix.Kind getKind() {
        if (kind == null) {
            return Matrix.Kind.ANY;
        } else {
            return kind;
        }
    }

    /**
     * Sets the value of the kind property.
     * 
     * @param value
     *     allowed object is
     *     {@link Matrix.Kind }
     *     
     */
    public Matrix setKind(Matrix.Kind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Gets the value of the nbRows property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNbRows() {
        return nbRows;
    }

    /**
     * Sets the value of the nbRows property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public Matrix setNbRows(Integer nbRows) {
        this.nbRows = nbRows;
        return this;
    }

    /**
     * Gets the value of the nbCols property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNbCols() {
        return nbCols;
    }

    /**
     * Sets the value of the nbCols property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public Matrix setNbCols(Integer nbCols) {
        this.nbCols = nbCols;
        return this;
    }

    /**
     * Gets the value of the diagDefault property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getDiagDefault() {
        return diagDefault;
    }

    /**
     * Sets the value of the diagDefault property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Matrix setDiagDefault(Double diagDefault) {
        this.diagDefault = diagDefault;
        return this;
    }

    /**
     * Gets the value of the offDiagDefault property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getOffDiagDefault() {
        return offDiagDefault;
    }

    /**
     * Sets the value of the offDiagDefault property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Matrix setOffDiagDefault(Double offDiagDefault) {
        this.offDiagDefault = offDiagDefault;
        return this;
    }

    /**
     * Gets the value of the arrays property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the arrays property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getArrays().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Array }
     * 
     * 
     */
    public List<Array> getArrays() {
        if (arrays == null) {
            arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    /**
     * Gets the value of the matCells property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the matCells property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMatCells().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MatCell }
     * 
     * 
     */
    public List<MatCell> getMatCells() {
        if (matCells == null) {
            matCells = new ArrayList<MatCell>();
        }
        return this.matCells;
    }

    public boolean hasArrays() {
        return ((this.arrays!= null)&&(this.arrays.size()> 0));
    }

    public Matrix addArrays(Array... arrays) {
        getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    public boolean hasMatCells() {
        return ((this.matCells!= null)&&(this.matCells.size()> 0));
    }

    public Matrix addMatCells(MatCell... matCells) {
        getMatCells().addAll(Arrays.asList(matCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasArrays()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getArrays());
        }
        if ((status == VisitorAction.CONTINUE)&&hasMatCells()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getMatCells());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="diagonal"/>
     *     &lt;enumeration value="symmetric"/>
     *     &lt;enumeration value="any"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Kind {

        @XmlEnumValue("diagonal")
        DIAGONAL("diagonal"),
        @XmlEnumValue("symmetric")
        SYMMETRIC("symmetric"),
        @XmlEnumValue("any")
        ANY("any");
        private final String value;

        Kind(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Matrix.Kind fromValue(String v) {
            for (Matrix.Kind c: Matrix.Kind.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
