/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TestDistributions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "testDistributions", "modelVerification"})
@XmlRootElement(name="BaselineModel", namespace="http://www.dmg.org/PMML-4_2")
@Added(value=Version.PMML_4_1)
public class BaselineModel
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunctionType functionName;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_2")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name="TestDistributions", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private TestDistributions testDistributions;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public BaselineModel() {
    }

    public BaselineModel(MiningFunctionType functionName, MiningSchema miningSchema, TestDistributions testDistributions) {
        this.functionName = functionName;
        this.miningSchema = miningSchema;
        this.testDistributions = testDistributions;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public BaselineModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunctionType getFunctionName() {
        return this.functionName;
    }

    @Override
    public BaselineModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public BaselineModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return true;
        }
        return this.scorable;
    }

    @Override
    public BaselineModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public BaselineModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public BaselineModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public BaselineModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public BaselineModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public BaselineModel setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public BaselineModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TestDistributions getTestDistributions() {
        return this.testDistributions;
    }

    public BaselineModel setTestDistributions(TestDistributions testDistributions) {
        this.testDistributions = testDistributions;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public BaselineModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public BaselineModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        MiningSchema miningSchema = this.getMiningSchema();
        if (status == VisitorAction.CONTINUE && miningSchema != null) {
            status = miningSchema.accept(visitor);
        }
        Output output = this.getOutput();
        if (status == VisitorAction.CONTINUE && output != null) {
            status = output.accept(visitor);
        }
        ModelStats modelStats = this.getModelStats();
        if (status == VisitorAction.CONTINUE && modelStats != null) {
            status = modelStats.accept(visitor);
        }
        ModelExplanation modelExplanation = this.getModelExplanation();
        if (status == VisitorAction.CONTINUE && modelExplanation != null) {
            status = modelExplanation.accept(visitor);
        }
        Targets targets = this.getTargets();
        if (status == VisitorAction.CONTINUE && targets != null) {
            status = targets.accept(visitor);
        }
        LocalTransformations localTransformations = this.getLocalTransformations();
        if (status == VisitorAction.CONTINUE && localTransformations != null) {
            status = localTransformations.accept(visitor);
        }
        TestDistributions testDistributions = this.getTestDistributions();
        if (status == VisitorAction.CONTINUE && testDistributions != null) {
            status = testDistributions.accept(visitor);
        }
        ModelVerification modelVerification = this.getModelVerification();
        if (status == VisitorAction.CONTINUE && modelVerification != null) {
            status = modelVerification.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

