/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Characteristics;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "characteristics", "modelVerification"})
@XmlRootElement(name="Scorecard", namespace="http://www.dmg.org/PMML-4_2")
@Added(value=Version.PMML_4_1)
public class Scorecard
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunctionType functionName;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="initialScore")
    private Double initialScore;
    @XmlAttribute(name="useReasonCodes")
    private Boolean useReasonCodes;
    @XmlAttribute(name="reasonCodeAlgorithm")
    private ReasonCodeAlgorithm reasonCodeAlgorithm;
    @XmlAttribute(name="baselineScore")
    private Double baselineScore;
    @XmlAttribute(name="baselineMethod")
    private BaselineMethod baselineMethod;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_2")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name="Characteristics", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private Characteristics characteristics;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public Scorecard() {
    }

    public Scorecard(MiningFunctionType functionName, MiningSchema miningSchema, Characteristics characteristics) {
        this.functionName = functionName;
        this.miningSchema = miningSchema;
        this.characteristics = characteristics;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public Scorecard setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunctionType getFunctionName() {
        return this.functionName;
    }

    @Override
    public Scorecard setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public Scorecard setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public double getInitialScore() {
        if (this.initialScore == null) {
            return 0.0;
        }
        return this.initialScore;
    }

    public Scorecard setInitialScore(Double initialScore) {
        this.initialScore = initialScore;
        return this;
    }

    public boolean isUseReasonCodes() {
        if (this.useReasonCodes == null) {
            return true;
        }
        return this.useReasonCodes;
    }

    public Scorecard setUseReasonCodes(Boolean useReasonCodes) {
        this.useReasonCodes = useReasonCodes;
        return this;
    }

    public ReasonCodeAlgorithm getReasonCodeAlgorithm() {
        if (this.reasonCodeAlgorithm == null) {
            return ReasonCodeAlgorithm.POINTS_BELOW;
        }
        return this.reasonCodeAlgorithm;
    }

    public Scorecard setReasonCodeAlgorithm(ReasonCodeAlgorithm reasonCodeAlgorithm) {
        this.reasonCodeAlgorithm = reasonCodeAlgorithm;
        return this;
    }

    public Double getBaselineScore() {
        return this.baselineScore;
    }

    public Scorecard setBaselineScore(Double baselineScore) {
        this.baselineScore = baselineScore;
        return this;
    }

    public BaselineMethod getBaselineMethod() {
        if (this.baselineMethod == null) {
            return BaselineMethod.OTHER;
        }
        return this.baselineMethod;
    }

    public Scorecard setBaselineMethod(BaselineMethod baselineMethod) {
        this.baselineMethod = baselineMethod;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return true;
        }
        return this.scorable;
    }

    @Override
    public Scorecard setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public Scorecard setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public Scorecard setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public Scorecard setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public Scorecard setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public Scorecard setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public Scorecard setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Characteristics getCharacteristics() {
        return this.characteristics;
    }

    public Scorecard setCharacteristics(Characteristics characteristics) {
        this.characteristics = characteristics;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public Scorecard setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public Scorecard addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        MiningSchema miningSchema = this.getMiningSchema();
        if (status == VisitorAction.CONTINUE && miningSchema != null) {
            status = miningSchema.accept(visitor);
        }
        Output output = this.getOutput();
        if (status == VisitorAction.CONTINUE && output != null) {
            status = output.accept(visitor);
        }
        ModelStats modelStats = this.getModelStats();
        if (status == VisitorAction.CONTINUE && modelStats != null) {
            status = modelStats.accept(visitor);
        }
        ModelExplanation modelExplanation = this.getModelExplanation();
        if (status == VisitorAction.CONTINUE && modelExplanation != null) {
            status = modelExplanation.accept(visitor);
        }
        Targets targets = this.getTargets();
        if (status == VisitorAction.CONTINUE && targets != null) {
            status = targets.accept(visitor);
        }
        LocalTransformations localTransformations = this.getLocalTransformations();
        if (status == VisitorAction.CONTINUE && localTransformations != null) {
            status = localTransformations.accept(visitor);
        }
        Characteristics characteristics = this.getCharacteristics();
        if (status == VisitorAction.CONTINUE && characteristics != null) {
            status = characteristics.accept(visitor);
        }
        ModelVerification modelVerification = this.getModelVerification();
        if (status == VisitorAction.CONTINUE && modelVerification != null) {
            status = modelVerification.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ReasonCodeAlgorithm {
        POINTS_ABOVE("pointsAbove"),
        POINTS_BELOW("pointsBelow");

        private final String value;

        private ReasonCodeAlgorithm(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ReasonCodeAlgorithm fromValue(String v) {
            for (ReasonCodeAlgorithm c : ReasonCodeAlgorithm.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum BaselineMethod {
        MAX("max"),
        MIN("min"),
        MEAN("mean"),
        NEUTRAL("neutral"),
        OTHER("other");

        private final String value;

        private BaselineMethod(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static BaselineMethod fromValue(String v) {
            for (BaselineMethod c : BaselineMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

