
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}NeuralInputs"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}NeuralLayer" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}NeuralOutputs" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="activationFunction" use="required" type="{http://www.dmg.org/PMML-4_2}ACTIVATION-FUNCTION" />
 *       &lt;attribute name="normalizationMethod" type="{http://www.dmg.org/PMML-4_2}NN-NORMALIZATION-METHOD" default="none" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *       &lt;attribute name="width" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="altitude" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="1.0" />
 *       &lt;attribute name="numberOfLayers" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "neuralInputs",
    "neuralLayers",
    "neuralOutputs",
    "modelVerification"
})
@XmlRootElement(name = "NeuralNetwork", namespace = "http://www.dmg.org/PMML-4_2")
public class NeuralNetwork
    extends Model
    implements HasExtensions
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "activationFunction", required = true)
    private ActivationFunctionType activationFunction;
    @XmlAttribute(name = "normalizationMethod")
    private NnNormalizationMethodType normalizationMethod;
    @XmlAttribute(name = "threshold")
    private Double threshold;
    @XmlAttribute(name = "width")
    private Double width;
    @XmlAttribute(name = "altitude")
    private Double altitude;
    @XmlAttribute(name = "numberOfLayers")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    private Integer numberOfLayers;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name = "NeuralInputs", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private NeuralInputs neuralInputs;
    @XmlElement(name = "NeuralLayer", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<NeuralLayer> neuralLayers;
    @XmlElement(name = "NeuralOutputs", namespace = "http://www.dmg.org/PMML-4_2")
    private NeuralOutputs neuralOutputs;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public NeuralNetwork() {
        super();
    }

    public NeuralNetwork(final MiningFunctionType functionName, final ActivationFunctionType activationFunction, final MiningSchema miningSchema, final NeuralInputs neuralInputs, final List<NeuralLayer> neuralLayers) {
        super();
        this.functionName = functionName;
        this.activationFunction = activationFunction;
        this.miningSchema = miningSchema;
        this.neuralInputs = neuralInputs;
        this.neuralLayers = neuralLayers;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public NeuralNetwork setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param functionName
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public NeuralNetwork setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public NeuralNetwork setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the activationFunction property.
     * 
     * @return
     *     possible object is
     *     {@link ActivationFunctionType }
     *     
     */
    public ActivationFunctionType getActivationFunction() {
        return activationFunction;
    }

    /**
     * Sets the value of the activationFunction property.
     * 
     * @param activationFunction
     *     allowed object is
     *     {@link ActivationFunctionType }
     *     
     */
    public NeuralNetwork setActivationFunction(ActivationFunctionType activationFunction) {
        this.activationFunction = activationFunction;
        return this;
    }

    /**
     * Gets the value of the normalizationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link NnNormalizationMethodType }
     *     
     */
    public NnNormalizationMethodType getNormalizationMethod() {
        if (normalizationMethod == null) {
            return NnNormalizationMethodType.NONE;
        } else {
            return normalizationMethod;
        }
    }

    /**
     * Sets the value of the normalizationMethod property.
     * 
     * @param normalizationMethod
     *     allowed object is
     *     {@link NnNormalizationMethodType }
     *     
     */
    public NeuralNetwork setNormalizationMethod(NnNormalizationMethodType normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getThreshold() {
        if (threshold == null) {
            return  0.0D;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param threshold
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NeuralNetwork setThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Gets the value of the width property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getWidth() {
        return width;
    }

    /**
     * Sets the value of the width property.
     * 
     * @param width
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NeuralNetwork setWidth(Double width) {
        this.width = width;
        return this;
    }

    /**
     * Gets the value of the altitude property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getAltitude() {
        if (altitude == null) {
            return  1.0D;
        } else {
            return altitude;
        }
    }

    /**
     * Sets the value of the altitude property.
     * 
     * @param altitude
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NeuralNetwork setAltitude(Double altitude) {
        this.altitude = altitude;
        return this;
    }

    /**
     * Gets the value of the numberOfLayers property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfLayers() {
        return numberOfLayers;
    }

    /**
     * Sets the value of the numberOfLayers property.
     * 
     * @param numberOfLayers
     *     allowed object is
     *     {@link String }
     *     
     */
    public NeuralNetwork setNumberOfLayers(Integer numberOfLayers) {
        this.numberOfLayers = numberOfLayers;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public NeuralNetwork setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public NeuralNetwork setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public NeuralNetwork setOutput(Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public NeuralNetwork setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public NeuralNetwork setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public NeuralNetwork setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public NeuralNetwork setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the neuralInputs property.
     * 
     * @return
     *     possible object is
     *     {@link NeuralInputs }
     *     
     */
    public NeuralInputs getNeuralInputs() {
        return neuralInputs;
    }

    /**
     * Sets the value of the neuralInputs property.
     * 
     * @param neuralInputs
     *     allowed object is
     *     {@link NeuralInputs }
     *     
     */
    public NeuralNetwork setNeuralInputs(NeuralInputs neuralInputs) {
        this.neuralInputs = neuralInputs;
        return this;
    }

    /**
     * Gets the value of the neuralLayers property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the neuralLayers property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNeuralLayers().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NeuralLayer }
     * 
     * 
     */
    public List<NeuralLayer> getNeuralLayers() {
        if (neuralLayers == null) {
            neuralLayers = new ArrayList<NeuralLayer>();
        }
        return this.neuralLayers;
    }

    /**
     * Gets the value of the neuralOutputs property.
     * 
     * @return
     *     possible object is
     *     {@link NeuralOutputs }
     *     
     */
    public NeuralOutputs getNeuralOutputs() {
        return neuralOutputs;
    }

    /**
     * Sets the value of the neuralOutputs property.
     * 
     * @param neuralOutputs
     *     allowed object is
     *     {@link NeuralOutputs }
     *     
     */
    public NeuralNetwork setNeuralOutputs(NeuralOutputs neuralOutputs) {
        this.neuralOutputs = neuralOutputs;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public NeuralNetwork setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NeuralNetwork addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeuralLayers() {
        return ((this.neuralLayers!= null)&&(this.neuralLayers.size()> 0));
    }

    public NeuralNetwork addNeuralLayers(NeuralLayer... neuralLayers) {
        getNeuralLayers().addAll(Arrays.asList(neuralLayers));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getNeuralInputs());
        }
        if ((status == VisitorAction.CONTINUE)&&hasNeuralLayers()) {
            status = PMMLObject.traverse(visitor, getNeuralLayers());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getNeuralOutputs(), getModelVerification());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
