
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Required;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;sequence>
 *           &lt;choice>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}LinearKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}PolynomialKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}RadialBasisKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}SigmoidKernelType"/>
 *           &lt;/choice>
 *         &lt;/sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}VectorDictionary"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}SupportVectorMachine" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *       &lt;attribute name="svmRepresentation" type="{http://www.dmg.org/PMML-4_2}SVM-REPRESENTATION" default="SupportVectors" />
 *       &lt;attribute name="alternateBinaryTargetCategory" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="classificationMethod" type="{http://www.dmg.org/PMML-4_2}SVM-CLASSIFICATION-METHOD" default="OneAgainstAll" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "kernel",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
@XmlRootElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_2")
public class SupportVectorMachineModel
    extends Model
    implements HasExtensions
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "threshold")
    @Added(Version.PMML_4_0)
    private Double threshold;
    @XmlAttribute(name = "svmRepresentation")
    private SvmRepresentationType svmRepresentation;
    @XmlAttribute(name = "alternateBinaryTargetCategory")
    @Added(Version.PMML_3_1)
    @Removed(Version.PMML_4_0)
    private String alternateBinaryTargetCategory;
    @XmlAttribute(name = "classificationMethod")
    @Added(Version.PMML_4_0)
    private SvmClassificationMethodType classificationMethod;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElements({
        @XmlElement(name = "LinearKernelType", namespace = "http://www.dmg.org/PMML-4_2", type = LinearKernel.class),
        @XmlElement(name = "PolynomialKernelType", namespace = "http://www.dmg.org/PMML-4_2", type = PolynomialKernel.class),
        @XmlElement(name = "RadialBasisKernelType", namespace = "http://www.dmg.org/PMML-4_2", type = RadialBasisKernel.class),
        @XmlElement(name = "SigmoidKernelType", namespace = "http://www.dmg.org/PMML-4_2", type = SigmoidKernel.class)
    })
    private Kernel kernel;
    @XmlElement(name = "VectorDictionary", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    @Required(Version.PMML_3_1)
    private VectorDictionary vectorDictionary;
    @XmlElement(name = "SupportVectorMachine", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public SupportVectorMachineModel() {
        super();
    }

    public SupportVectorMachineModel(final MiningFunctionType functionName, final MiningSchema miningSchema, final VectorDictionary vectorDictionary, final List<SupportVectorMachine> supportVectorMachines) {
        super();
        this.functionName = functionName;
        this.miningSchema = miningSchema;
        this.vectorDictionary = vectorDictionary;
        this.supportVectorMachines = supportVectorMachines;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public SupportVectorMachineModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param functionName
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public SupportVectorMachineModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public SupportVectorMachineModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getThreshold() {
        if (threshold == null) {
            return  0.0D;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param threshold
     *     allowed object is
     *     {@link Double }
     *     
     */
    public SupportVectorMachineModel setThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Gets the value of the svmRepresentation property.
     * 
     * @return
     *     possible object is
     *     {@link SvmRepresentationType }
     *     
     */
    public SvmRepresentationType getSvmRepresentation() {
        if (svmRepresentation == null) {
            return SvmRepresentationType.SUPPORT_VECTORS;
        } else {
            return svmRepresentation;
        }
    }

    /**
     * Sets the value of the svmRepresentation property.
     * 
     * @param svmRepresentation
     *     allowed object is
     *     {@link SvmRepresentationType }
     *     
     */
    public SupportVectorMachineModel setSvmRepresentation(SvmRepresentationType svmRepresentation) {
        this.svmRepresentation = svmRepresentation;
        return this;
    }

    /**
     * Gets the value of the alternateBinaryTargetCategory property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlternateBinaryTargetCategory() {
        return alternateBinaryTargetCategory;
    }

    /**
     * Sets the value of the alternateBinaryTargetCategory property.
     * 
     * @param alternateBinaryTargetCategory
     *     allowed object is
     *     {@link String }
     *     
     */
    public SupportVectorMachineModel setAlternateBinaryTargetCategory(String alternateBinaryTargetCategory) {
        this.alternateBinaryTargetCategory = alternateBinaryTargetCategory;
        return this;
    }

    /**
     * Gets the value of the classificationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link SvmClassificationMethodType }
     *     
     */
    public SvmClassificationMethodType getClassificationMethod() {
        if (classificationMethod == null) {
            return SvmClassificationMethodType.ONE_AGAINST_ALL;
        } else {
            return classificationMethod;
        }
    }

    /**
     * Sets the value of the classificationMethod property.
     * 
     * @param classificationMethod
     *     allowed object is
     *     {@link SvmClassificationMethodType }
     *     
     */
    public SupportVectorMachineModel setClassificationMethod(SvmClassificationMethodType classificationMethod) {
        this.classificationMethod = classificationMethod;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public SupportVectorMachineModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public SupportVectorMachineModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public SupportVectorMachineModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public SupportVectorMachineModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public SupportVectorMachineModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public SupportVectorMachineModel setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public SupportVectorMachineModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the kernel property.
     * 
     * @return
     *     possible object is
     *     {@link LinearKernel }
     *     {@link PolynomialKernel }
     *     {@link RadialBasisKernel }
     *     {@link SigmoidKernel }
     *     
     */
    public Kernel getKernel() {
        return kernel;
    }

    /**
     * Sets the value of the kernel property.
     * 
     * @param kernel
     *     allowed object is
     *     {@link LinearKernel }
     *     {@link PolynomialKernel }
     *     {@link RadialBasisKernel }
     *     {@link SigmoidKernel }
     *     
     */
    public SupportVectorMachineModel setKernel(Kernel kernel) {
        this.kernel = kernel;
        return this;
    }

    /**
     * Gets the value of the vectorDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link VectorDictionary }
     *     
     */
    public VectorDictionary getVectorDictionary() {
        return vectorDictionary;
    }

    /**
     * Sets the value of the vectorDictionary property.
     * 
     * @param vectorDictionary
     *     allowed object is
     *     {@link VectorDictionary }
     *     
     */
    public SupportVectorMachineModel setVectorDictionary(VectorDictionary vectorDictionary) {
        this.vectorDictionary = vectorDictionary;
        return this;
    }

    /**
     * Gets the value of the supportVectorMachines property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportVectorMachines property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportVectorMachines().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupportVectorMachine }
     * 
     * 
     */
    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (supportVectorMachines == null) {
            supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public SupportVectorMachineModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SupportVectorMachineModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSupportVectorMachines() {
        return ((this.supportVectorMachines!= null)&&(this.supportVectorMachines.size()> 0));
    }

    public SupportVectorMachineModel addSupportVectorMachines(SupportVectorMachine... supportVectorMachines) {
        getSupportVectorMachines().addAll(Arrays.asList(supportVectorMachines));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getKernel(), getVectorDictionary());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSupportVectorMachines()) {
                status = PMMLObject.traverse(visitor, getSupportVectorMachines());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
