/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Term;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="NumericPredictor", namespace="http://www.dmg.org/PMML-4_2")
public class NumericPredictor
extends Term
implements HasExtensions {
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name="exponent")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer exponent;
    @XmlAttribute(name="coefficient", required=true)
    private double coefficient;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    private static final Integer DEFAULT_EXPONENT = new IntegerAdapter().unmarshal("1");

    public NumericPredictor() {
    }

    public NumericPredictor(FieldName name, double coefficient) {
        this.name = name;
        this.coefficient = coefficient;
    }

    @Override
    public FieldName getName() {
        return this.name;
    }

    @Override
    public NumericPredictor setName(FieldName name) {
        this.name = name;
        return this;
    }

    public Integer getExponent() {
        if (this.exponent == null) {
            return DEFAULT_EXPONENT;
        }
        return this.exponent;
    }

    public NumericPredictor setExponent(Integer exponent) {
        this.exponent = exponent;
        return this;
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public NumericPredictor setCoefficient(double coefficient) {
        this.coefficient = coefficient;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public NumericPredictor addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

