/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Constraints;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Item;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Sequence;
import org.dmg.pmml.SequenceRule;
import org.dmg.pmml.SetPredicate;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "modelStats", "localTransformations", "constraints", "items", "itemsets", "setPredicates", "sequences", "sequenceRules"})
@XmlRootElement(name="SequenceModel", namespace="http://www.dmg.org/PMML-4_2")
public class SequenceModel
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunctionType functionName;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="numberOfTransactions")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer numberOfTransactions;
    @XmlAttribute(name="maxNumberOfItemsPerTransaction")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer maxNumberOfItemsPerTransaction;
    @XmlAttribute(name="avgNumberOfItemsPerTransaction")
    private Double avgNumberOfItemsPerTransaction;
    @XmlAttribute(name="numberOfTransactionGroups")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Added(value=Version.PMML_3_1)
    private Integer numberOfTransactionGroups;
    @XmlAttribute(name="maxNumberOfTAsPerTAGroup")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Added(value=Version.PMML_3_1)
    private Integer maxNumberOfTAsPerTAGroup;
    @XmlAttribute(name="avgNumberOfTAsPerTAGroup")
    @Added(value=Version.PMML_3_1)
    private Double avgNumberOfTAsPerTAGroup;
    @XmlAttribute(name="minimumSupport", required=true)
    @Removed(value=Version.PMML_3_1)
    private double minimumSupport;
    @XmlAttribute(name="minimumConfidence", required=true)
    @Removed(value=Version.PMML_3_1)
    private double minimumConfidence;
    @XmlAttribute(name="lengthLimit")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    private Integer lengthLimit;
    @XmlAttribute(name="numberOfItems", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    private Integer numberOfItems;
    @XmlAttribute(name="numberOfSets", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    private Integer numberOfSets;
    @XmlAttribute(name="numberOfSequences", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    private Integer numberOfSequences;
    @XmlAttribute(name="numberOfRules", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    private Integer numberOfRules;
    @XmlAttribute(name="timeWindowWidth")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    private Integer timeWindowWidth;
    @XmlAttribute(name="minimumTime")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    private Integer minimumTime;
    @XmlAttribute(name="maximumTime")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    private Integer maximumTime;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name="Constraints", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_3_1)
    private Constraints constraints;
    @XmlElement(name="Item", namespace="http://www.dmg.org/PMML-4_2")
    private List<Item> items;
    @XmlElement(name="Itemset", namespace="http://www.dmg.org/PMML-4_2")
    private List<Itemset> itemsets;
    @XmlElement(name="SetPredicate", namespace="http://www.dmg.org/PMML-4_2")
    private List<SetPredicate> setPredicates;
    @XmlElement(name="Sequence", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private List<Sequence> sequences;
    @XmlElement(name="SequenceRule", namespace="http://www.dmg.org/PMML-4_2")
    private List<SequenceRule> sequenceRules;
    private static final Boolean DEFAULT_SCORABLE = true;

    public SequenceModel() {
    }

    public SequenceModel(MiningFunctionType functionName, double minimumSupport, double minimumConfidence, Integer numberOfItems, Integer numberOfSets, Integer numberOfSequences, Integer numberOfRules, MiningSchema miningSchema, List<Sequence> sequences) {
        this.functionName = functionName;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfSets = numberOfSets;
        this.numberOfSequences = numberOfSequences;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
        this.sequences = sequences;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public SequenceModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunctionType getFunctionName() {
        return this.functionName;
    }

    @Override
    public SequenceModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public SequenceModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    public SequenceModel setNumberOfTransactions(Integer numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    public Integer getMaxNumberOfItemsPerTransaction() {
        return this.maxNumberOfItemsPerTransaction;
    }

    public SequenceModel setMaxNumberOfItemsPerTransaction(Integer maxNumberOfItemsPerTransaction) {
        this.maxNumberOfItemsPerTransaction = maxNumberOfItemsPerTransaction;
        return this;
    }

    public Double getAvgNumberOfItemsPerTransaction() {
        return this.avgNumberOfItemsPerTransaction;
    }

    public SequenceModel setAvgNumberOfItemsPerTransaction(Double avgNumberOfItemsPerTransaction) {
        this.avgNumberOfItemsPerTransaction = avgNumberOfItemsPerTransaction;
        return this;
    }

    public Integer getNumberOfTransactionGroups() {
        return this.numberOfTransactionGroups;
    }

    public SequenceModel setNumberOfTransactionGroups(Integer numberOfTransactionGroups) {
        this.numberOfTransactionGroups = numberOfTransactionGroups;
        return this;
    }

    public Integer getMaxNumberOfTAsPerTAGroup() {
        return this.maxNumberOfTAsPerTAGroup;
    }

    public SequenceModel setMaxNumberOfTAsPerTAGroup(Integer maxNumberOfTAsPerTAGroup) {
        this.maxNumberOfTAsPerTAGroup = maxNumberOfTAsPerTAGroup;
        return this;
    }

    public Double getAvgNumberOfTAsPerTAGroup() {
        return this.avgNumberOfTAsPerTAGroup;
    }

    public SequenceModel setAvgNumberOfTAsPerTAGroup(Double avgNumberOfTAsPerTAGroup) {
        this.avgNumberOfTAsPerTAGroup = avgNumberOfTAsPerTAGroup;
        return this;
    }

    public double getMinimumSupport() {
        return this.minimumSupport;
    }

    public SequenceModel setMinimumSupport(double minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public double getMinimumConfidence() {
        return this.minimumConfidence;
    }

    public SequenceModel setMinimumConfidence(double minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Integer getLengthLimit() {
        return this.lengthLimit;
    }

    public SequenceModel setLengthLimit(Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    public Integer getNumberOfItems() {
        return this.numberOfItems;
    }

    public SequenceModel setNumberOfItems(Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    public Integer getNumberOfSets() {
        return this.numberOfSets;
    }

    public SequenceModel setNumberOfSets(Integer numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    public Integer getNumberOfSequences() {
        return this.numberOfSequences;
    }

    public SequenceModel setNumberOfSequences(Integer numberOfSequences) {
        this.numberOfSequences = numberOfSequences;
        return this;
    }

    public Integer getNumberOfRules() {
        return this.numberOfRules;
    }

    public SequenceModel setNumberOfRules(Integer numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    public Integer getTimeWindowWidth() {
        return this.timeWindowWidth;
    }

    public SequenceModel setTimeWindowWidth(Integer timeWindowWidth) {
        this.timeWindowWidth = timeWindowWidth;
        return this;
    }

    public Integer getMinimumTime() {
        return this.minimumTime;
    }

    public SequenceModel setMinimumTime(Integer minimumTime) {
        this.minimumTime = minimumTime;
        return this;
    }

    public Integer getMaximumTime() {
        return this.maximumTime;
    }

    public SequenceModel setMaximumTime(Integer maximumTime) {
        this.maximumTime = maximumTime;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public SequenceModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public SequenceModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public SequenceModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public SequenceModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public SequenceModel setConstraints(Constraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public List<Item> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        return this.items;
    }

    public List<Itemset> getItemsets() {
        if (this.itemsets == null) {
            this.itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    public List<SetPredicate> getSetPredicates() {
        if (this.setPredicates == null) {
            this.setPredicates = new ArrayList<SetPredicate>();
        }
        return this.setPredicates;
    }

    public List<Sequence> getSequences() {
        if (this.sequences == null) {
            this.sequences = new ArrayList<Sequence>();
        }
        return this.sequences;
    }

    public List<SequenceRule> getSequenceRules() {
        if (this.sequenceRules == null) {
            this.sequenceRules = new ArrayList<SequenceRule>();
        }
        return this.sequenceRules;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public SequenceModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasItems() {
        return this.items != null && this.items.size() > 0;
    }

    public SequenceModel addItems(Item ... items) {
        this.getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return this.itemsets != null && this.itemsets.size() > 0;
    }

    public SequenceModel addItemsets(Itemset ... itemsets) {
        this.getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasSetPredicates() {
        return this.setPredicates != null && this.setPredicates.size() > 0;
    }

    public SequenceModel addSetPredicates(SetPredicate ... setPredicates) {
        this.getSetPredicates().addAll(Arrays.asList(setPredicates));
        return this;
    }

    public boolean hasSequences() {
        return this.sequences != null && this.sequences.size() > 0;
    }

    public SequenceModel addSequences(Sequence ... sequences) {
        this.getSequences().addAll(Arrays.asList(sequences));
        return this;
    }

    public boolean hasSequenceRules() {
        return this.sequenceRules != null && this.sequenceRules.size() > 0;
    }

    public SequenceModel addSequenceRules(SequenceRule ... sequenceRules) {
        this.getSequenceRules().addAll(Arrays.asList(sequenceRules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getModelStats(), this.getLocalTransformations(), this.getConstraints());
            }
            if (status == VisitorAction.CONTINUE && this.hasItems()) {
                status = PMMLObject.traverse(visitor, this.getItems());
            }
            if (status == VisitorAction.CONTINUE && this.hasItemsets()) {
                status = PMMLObject.traverse(visitor, this.getItemsets());
            }
            if (status == VisitorAction.CONTINUE && this.hasSetPredicates()) {
                status = PMMLObject.traverse(visitor, this.getSetPredicates());
            }
            if (status == VisitorAction.CONTINUE && this.hasSequences()) {
                status = PMMLObject.traverse(visitor, this.getSequences());
            }
            if (status == VisitorAction.CONTINUE && this.hasSequenceRules()) {
                status = PMMLObject.traverse(visitor, this.getSequenceRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

