/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.DocumentTermMatrix;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TextCorpus;
import org.dmg.pmml.TextDictionary;
import org.dmg.pmml.TextModelNormalization;
import org.dmg.pmml.TextModelSimiliarity;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "textDictionary", "textCorpus", "documentTermMatrix", "textModelNormalization", "textModelSimiliarity", "modelVerification"})
@XmlRootElement(name="TextModel", namespace="http://www.dmg.org/PMML-4_2")
@Deprecated(value=Version.PMML_4_2)
public class TextModel
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunctionType functionName;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="numberOfTerms", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer numberOfTerms;
    @XmlAttribute(name="numberOfDocuments", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer numberOfDocuments;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name="TextDictionary", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private TextDictionary textDictionary;
    @XmlElement(name="TextCorpus", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private TextCorpus textCorpus;
    @XmlElement(name="DocumentTermMatrix", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private DocumentTermMatrix documentTermMatrix;
    @XmlElement(name="TextModelNormalization", namespace="http://www.dmg.org/PMML-4_2")
    private TextModelNormalization textModelNormalization;
    @XmlElement(name="TextModelSimiliarity", namespace="http://www.dmg.org/PMML-4_2")
    private TextModelSimiliarity textModelSimiliarity;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;

    public TextModel() {
    }

    public TextModel(MiningFunctionType functionName, Integer numberOfTerms, Integer numberOfDocuments, MiningSchema miningSchema, TextDictionary textDictionary, TextCorpus textCorpus, DocumentTermMatrix documentTermMatrix) {
        this.functionName = functionName;
        this.numberOfTerms = numberOfTerms;
        this.numberOfDocuments = numberOfDocuments;
        this.miningSchema = miningSchema;
        this.textDictionary = textDictionary;
        this.textCorpus = textCorpus;
        this.documentTermMatrix = documentTermMatrix;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public TextModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunctionType getFunctionName() {
        return this.functionName;
    }

    @Override
    public TextModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public TextModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTerms() {
        return this.numberOfTerms;
    }

    public TextModel setNumberOfTerms(Integer numberOfTerms) {
        this.numberOfTerms = numberOfTerms;
        return this;
    }

    public Integer getNumberOfDocuments() {
        return this.numberOfDocuments;
    }

    public TextModel setNumberOfDocuments(Integer numberOfDocuments) {
        this.numberOfDocuments = numberOfDocuments;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public TextModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public TextModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public TextModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public TextModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public TextModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public TextModel setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public TextModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TextDictionary getTextDictionary() {
        return this.textDictionary;
    }

    public TextModel setTextDictionary(TextDictionary textDictionary) {
        this.textDictionary = textDictionary;
        return this;
    }

    public TextCorpus getTextCorpus() {
        return this.textCorpus;
    }

    public TextModel setTextCorpus(TextCorpus textCorpus) {
        this.textCorpus = textCorpus;
        return this;
    }

    public DocumentTermMatrix getDocumentTermMatrix() {
        return this.documentTermMatrix;
    }

    public TextModel setDocumentTermMatrix(DocumentTermMatrix documentTermMatrix) {
        this.documentTermMatrix = documentTermMatrix;
        return this;
    }

    public TextModelNormalization getTextModelNormalization() {
        return this.textModelNormalization;
    }

    public TextModel setTextModelNormalization(TextModelNormalization textModelNormalization) {
        this.textModelNormalization = textModelNormalization;
        return this;
    }

    public TextModelSimiliarity getTextModelSimiliarity() {
        return this.textModelSimiliarity;
    }

    public TextModel setTextModelSimiliarity(TextModelSimiliarity textModelSimiliarity) {
        this.textModelSimiliarity = textModelSimiliarity;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public TextModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public TextModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getTextDictionary(), this.getTextCorpus(), this.getDocumentTermMatrix(), this.getTextModelNormalization(), this.getTextModelSimiliarity(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

