/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "fieldRefs"})
@XmlRootElement(name="VectorFields", namespace="http://www.dmg.org/PMML-4_2")
@Added(value=Version.PMML_3_1)
public class VectorFields
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="numberOfFields")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer numberOfFields;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="FieldRef", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private List<FieldRef> fieldRefs;

    public VectorFields() {
    }

    public VectorFields(List<FieldRef> fieldRefs) {
        this.fieldRefs = fieldRefs;
    }

    public Integer getNumberOfFields() {
        return this.numberOfFields;
    }

    public VectorFields setNumberOfFields(Integer numberOfFields) {
        this.numberOfFields = numberOfFields;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<FieldRef> getFieldRefs() {
        if (this.fieldRefs == null) {
            this.fieldRefs = new ArrayList<FieldRef>();
        }
        return this.fieldRefs;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public VectorFields addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldRefs() {
        return this.fieldRefs != null && this.fieldRefs.size() > 0;
    }

    public VectorFields addFieldRefs(FieldRef ... fieldRefs) {
        this.getFieldRefs().addAll(Arrays.asList(fieldRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasFieldRefs()) {
                status = PMMLObject.traverse(visitor, this.getFieldRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

