/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SupportVector;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "supportVectors"})
@XmlRootElement(name="SupportVectors", namespace="http://www.dmg.org/PMML-4_2")
public class SupportVectors
extends PMMLObject
implements Iterable<SupportVector>,
HasExtensions {
    @XmlAttribute(name="numberOfSupportVectors")
    private Integer numberOfSupportVectors;
    @XmlAttribute(name="numberOfAttributes")
    private Integer numberOfAttributes;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="SupportVector", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private List<SupportVector> supportVectors;

    public SupportVectors() {
    }

    public SupportVectors(List<SupportVector> supportVectors) {
        this.supportVectors = supportVectors;
    }

    public Integer getNumberOfSupportVectors() {
        return this.numberOfSupportVectors;
    }

    public SupportVectors setNumberOfSupportVectors(Integer numberOfSupportVectors) {
        this.numberOfSupportVectors = numberOfSupportVectors;
        return this;
    }

    public Integer getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public SupportVectors setNumberOfAttributes(Integer numberOfAttributes) {
        this.numberOfAttributes = numberOfAttributes;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<SupportVector> getSupportVectors() {
        if (this.supportVectors == null) {
            this.supportVectors = new ArrayList<SupportVector>();
        }
        return this.supportVectors;
    }

    @Override
    public Iterator<SupportVector> iterator() {
        return this.getSupportVectors().iterator();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public SupportVectors addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSupportVectors() {
        return this.supportVectors != null && this.supportVectors.size() > 0;
    }

    public SupportVectors addSupportVectors(SupportVector ... supportVectors) {
        this.getSupportVectors().addAll(Arrays.asList(supportVectors));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasSupportVectors()) {
                status = PMMLObject.traverse(visitor, this.getSupportVectors());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

