/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.dmg.pmml.PMML;
import org.jpmml.model.DirectByteArrayOutputStream;

public class SerializationUtil {
    private SerializationUtil() {
    }

    public static PMML deserializePMML(InputStream is) throws ClassNotFoundException, IOException {
        return (PMML)SerializationUtil.deserialize(is);
    }

    private static Object deserialize(InputStream is) throws ClassNotFoundException, IOException {
        FilterInputStream safeIs = new FilterInputStream(is){

            @Override
            public void close() {
            }
        };
        try (ObjectInputStream ois = new ObjectInputStream(safeIs);){
            Object object = ois.readObject();
            return object;
        }
    }

    public static void serializePMML(PMML pmml, OutputStream os) throws IOException {
        SerializationUtil.serialize(pmml, os);
    }

    private static <S extends Serializable> void serialize(S object, OutputStream os) throws IOException {
        FilterOutputStream safeOs = new FilterOutputStream(os){

            @Override
            public void close() throws IOException {
                super.flush();
            }
        };
        try (ObjectOutputStream oos = new ObjectOutputStream(safeOs);){
            oos.writeObject(object);
            oos.flush();
        }
    }

    public static <S extends Serializable> S clone(S object) throws ClassNotFoundException, IOException {
        return SerializationUtil.clone(object, 0x100000);
    }

    public static <S extends Serializable> S clone(S object, int capacity) throws ClassNotFoundException, IOException {
        DirectByteArrayOutputStream buffer = new DirectByteArrayOutputStream(capacity);
        SerializationUtil.serialize(object, buffer);
        try (InputStream is = buffer.getInputStream();){
            Serializable serializable = (Serializable)SerializationUtil.deserialize(is);
            return (S)serializable;
        }
    }
}

