/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="TextModelNormalization", namespace="http://www.dmg.org/PMML-4_2")
public class TextModelNormalization
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="localTermWeights")
    private LocalTermWeights localTermWeights;
    @XmlAttribute(name="globalTermWeights")
    private GlobalTermWeights globalTermWeights;
    @XmlAttribute(name="documentNormalization")
    private DocumentNormalization documentNormalization;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public LocalTermWeights getLocalTermWeights() {
        if (this.localTermWeights == null) {
            return LocalTermWeights.TERM_FREQUENCY;
        }
        return this.localTermWeights;
    }

    public TextModelNormalization setLocalTermWeights(LocalTermWeights localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    public GlobalTermWeights getGlobalTermWeights() {
        if (this.globalTermWeights == null) {
            return GlobalTermWeights.INVERSE_DOCUMENT_FREQUENCY;
        }
        return this.globalTermWeights;
    }

    public TextModelNormalization setGlobalTermWeights(GlobalTermWeights globalTermWeights) {
        this.globalTermWeights = globalTermWeights;
        return this;
    }

    public DocumentNormalization getDocumentNormalization() {
        if (this.documentNormalization == null) {
            return DocumentNormalization.NONE;
        }
        return this.documentNormalization;
    }

    public TextModelNormalization setDocumentNormalization(DocumentNormalization documentNormalization) {
        this.documentNormalization = documentNormalization;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public TextModelNormalization addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum LocalTermWeights {
        TERM_FREQUENCY("termFrequency"),
        BINARY("binary"),
        LOGARITHMIC("logarithmic"),
        AUGMENTED_NORMALIZED_TERM_FREQUENCY("augmentedNormalizedTermFrequency");

        private final String value;

        private LocalTermWeights(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static LocalTermWeights fromValue(String v) {
            for (LocalTermWeights c : LocalTermWeights.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum GlobalTermWeights {
        INVERSE_DOCUMENT_FREQUENCY("inverseDocumentFrequency"),
        NONE("none"),
        GFIDF("GFIDF"),
        NORMAL("normal"),
        PROBABILISTIC_INVERSE("probabilisticInverse");

        private final String value;

        private GlobalTermWeights(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static GlobalTermWeights fromValue(String v) {
            for (GlobalTermWeights c : GlobalTermWeights.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum DocumentNormalization {
        NONE("none"),
        COSINE("cosine");

        private final String value;

        private DocumentNormalization(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static DocumentNormalization fromValue(String v) {
            for (DocumentNormalization c : DocumentNormalization.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

