
package org.jpmml.model.visitors;

import org.dmg.pmml.ARIMA;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Alternate;
import org.dmg.pmml.Annotation;
import org.dmg.pmml.Anova;
import org.dmg.pmml.AnovaRow;
import org.dmg.pmml.AntecedentSequence;
import org.dmg.pmml.AnyDistribution;
import org.dmg.pmml.Application;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.Attribute;
import org.dmg.pmml.BaseCumHazardTables;
import org.dmg.pmml.Baseline;
import org.dmg.pmml.BaselineCell;
import org.dmg.pmml.BaselineModel;
import org.dmg.pmml.BaselineStratum;
import org.dmg.pmml.BayesInput;
import org.dmg.pmml.BayesInputs;
import org.dmg.pmml.BayesOutput;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.BoundaryValueMeans;
import org.dmg.pmml.BoundaryValues;
import org.dmg.pmml.CategoricalPredictor;
import org.dmg.pmml.Categories;
import org.dmg.pmml.Category;
import org.dmg.pmml.CenterFields;
import org.dmg.pmml.Characteristic;
import org.dmg.pmml.Characteristics;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.ChildParent;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.ClassLabels;
import org.dmg.pmml.Cluster;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.ClusteringModelQuality;
import org.dmg.pmml.Coefficient;
import org.dmg.pmml.Coefficients;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Comparisons;
import org.dmg.pmml.ComplexPartialScore;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.CompoundRule;
import org.dmg.pmml.ConfusionMatrix;
import org.dmg.pmml.Connection;
import org.dmg.pmml.ConsequentSequence;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Constraints;
import org.dmg.pmml.ContStats;
import org.dmg.pmml.CorrelationFields;
import org.dmg.pmml.CorrelationMethods;
import org.dmg.pmml.CorrelationValues;
import org.dmg.pmml.Correlations;
import org.dmg.pmml.CountTable;
import org.dmg.pmml.Counts;
import org.dmg.pmml.Covariances;
import org.dmg.pmml.CovariateList;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Decision;
import org.dmg.pmml.DecisionTree;
import org.dmg.pmml.Decisions;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Delimiter;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.DiscrStats;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.DocumentTermMatrix;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.EventValues;
import org.dmg.pmml.ExponentialSmoothing;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FactorList;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.FieldValue;
import org.dmg.pmml.FieldValueCount;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.GeneralRegressionModel;
import org.dmg.pmml.Header;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.InstanceField;
import org.dmg.pmml.InstanceFields;
import org.dmg.pmml.IntSparseArray;
import org.dmg.pmml.Interval;
import org.dmg.pmml.Item;
import org.dmg.pmml.ItemRef;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.KNNInput;
import org.dmg.pmml.KNNInputs;
import org.dmg.pmml.KohonenMap;
import org.dmg.pmml.Level;
import org.dmg.pmml.LiftData;
import org.dmg.pmml.LiftGraph;
import org.dmg.pmml.LinearKernel;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.MatCell;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.MissingValueWeights;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelLiftGraph;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.MultivariateStat;
import org.dmg.pmml.MultivariateStats;
import org.dmg.pmml.NaiveBayesModel;
import org.dmg.pmml.NearestNeighborModel;
import org.dmg.pmml.NeuralInput;
import org.dmg.pmml.NeuralInputs;
import org.dmg.pmml.NeuralLayer;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.NeuralOutput;
import org.dmg.pmml.NeuralOutputs;
import org.dmg.pmml.Neuron;
import org.dmg.pmml.Node;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.NumericInfo;
import org.dmg.pmml.NumericPredictor;
import org.dmg.pmml.OptimumLiftGraph;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PCell;
import org.dmg.pmml.PCovCell;
import org.dmg.pmml.PCovMatrix;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PPCell;
import org.dmg.pmml.PPMatrix;
import org.dmg.pmml.PairCounts;
import org.dmg.pmml.ParamMatrix;
import org.dmg.pmml.Parameter;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.ParameterList;
import org.dmg.pmml.Partition;
import org.dmg.pmml.PartitionFieldStats;
import org.dmg.pmml.PoissonDistribution;
import org.dmg.pmml.PolynomialKernel;
import org.dmg.pmml.PredictiveModelQuality;
import org.dmg.pmml.Predictor;
import org.dmg.pmml.PredictorTerm;
import org.dmg.pmml.Quantile;
import org.dmg.pmml.ROC;
import org.dmg.pmml.ROCGraph;
import org.dmg.pmml.RadialBasisKernel;
import org.dmg.pmml.RandomLiftGraph;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.Regression;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RegressionTable;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.Row;
import org.dmg.pmml.RuleSelectionMethod;
import org.dmg.pmml.RuleSet;
import org.dmg.pmml.RuleSetModel;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Scorecard;
import org.dmg.pmml.SeasonalTrendDecomposition;
import org.dmg.pmml.SeasonalityExpoSmooth;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.dmg.pmml.Sequence;
import org.dmg.pmml.SequenceModel;
import org.dmg.pmml.SequenceReference;
import org.dmg.pmml.SequenceRule;
import org.dmg.pmml.SetPredicate;
import org.dmg.pmml.SetReference;
import org.dmg.pmml.SigmoidKernel;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleRule;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.SpectralAnalysis;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.SupportVector;
import org.dmg.pmml.SupportVectorMachine;
import org.dmg.pmml.SupportVectorMachineModel;
import org.dmg.pmml.SupportVectors;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.Tanimoto;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.TargetValueCount;
import org.dmg.pmml.TargetValueCounts;
import org.dmg.pmml.TargetValueStat;
import org.dmg.pmml.TargetValueStats;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Taxonomy;
import org.dmg.pmml.TestDistributions;
import org.dmg.pmml.TextCorpus;
import org.dmg.pmml.TextDictionary;
import org.dmg.pmml.TextDocument;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.TextModel;
import org.dmg.pmml.TextModelNormalization;
import org.dmg.pmml.TextModelSimiliarity;
import org.dmg.pmml.Time;
import org.dmg.pmml.TimeAnchor;
import org.dmg.pmml.TimeCycle;
import org.dmg.pmml.TimeException;
import org.dmg.pmml.TimeSeries;
import org.dmg.pmml.TimeSeriesModel;
import org.dmg.pmml.TimeValue;
import org.dmg.pmml.Timestamp;
import org.dmg.pmml.TrainingInstances;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.TrendExpoSmooth;
import org.dmg.pmml.True;
import org.dmg.pmml.UniformDistribution;
import org.dmg.pmml.UnivariateStats;
import org.dmg.pmml.Value;
import org.dmg.pmml.VectorDictionary;
import org.dmg.pmml.VectorFields;
import org.dmg.pmml.VectorInstance;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.XCoordinates;
import org.dmg.pmml.YCoordinates;

public abstract class AbstractSimpleVisitor
    extends AbstractVisitor
{


    public abstract VisitorAction visit(PMMLObject object);

    @Override
    public VisitorAction visit(NormDiscrete normDiscrete) {
        return visit(((PMMLObject) normDiscrete));
    }

    @Override
    public VisitorAction visit(Interval interval) {
        return visit(((PMMLObject) interval));
    }

    @Override
    public VisitorAction visit(Aggregate aggregate) {
        return visit(((PMMLObject) aggregate));
    }

    @Override
    public VisitorAction visit(TextIndex textIndex) {
        return visit(((PMMLObject) textIndex));
    }

    @Override
    public VisitorAction visit(OutputField outputField) {
        return visit(((PMMLObject) outputField));
    }

    @Override
    public VisitorAction visit(Array array) {
        return visit(((PMMLObject) array));
    }

    @Override
    public VisitorAction visit(AnovaRow anovaRow) {
        return visit(((PMMLObject) anovaRow));
    }

    @Override
    public VisitorAction visit(UnivariateStats univariateStats) {
        return visit(((PMMLObject) univariateStats));
    }

    @Override
    public VisitorAction visit(Matrix matrix) {
        return visit(((PMMLObject) matrix));
    }

    @Override
    public VisitorAction visit(PredictiveModelQuality predictiveModelQuality) {
        return visit(((PMMLObject) predictiveModelQuality));
    }

    @Override
    public VisitorAction visit(PartitionFieldStats partitionFieldStats) {
        return visit(((PMMLObject) partitionFieldStats));
    }

    @Override
    public VisitorAction visit(Target target) {
        return visit(((PMMLObject) target));
    }

    @Override
    public VisitorAction visit(Value value) {
        return visit(((PMMLObject) value));
    }

    @Override
    public VisitorAction visit(SimplePredicate simplePredicate) {
        return visit(((PMMLObject) simplePredicate));
    }

    @Override
    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        return visit(((PMMLObject) simpleSetPredicate));
    }

    @Override
    public VisitorAction visit(CompoundPredicate compoundPredicate) {
        return visit(((PMMLObject) compoundPredicate));
    }

    @Override
    public VisitorAction visit(DecisionTree decisionTree) {
        return visit(((PMMLObject) decisionTree));
    }

    @Override
    public VisitorAction visit(ComparisonMeasure comparisonMeasure) {
        return visit(((PMMLObject) comparisonMeasure));
    }

    @Override
    public VisitorAction visit(ClusteringField clusteringField) {
        return visit(((PMMLObject) clusteringField));
    }

    @Override
    public VisitorAction visit(ClusteringModel clusteringModel) {
        return visit(((PMMLObject) clusteringModel));
    }

    @Override
    public VisitorAction visit(PCovMatrix pCovMatrix) {
        return visit(((PMMLObject) pCovMatrix));
    }

    @Override
    public VisitorAction visit(GeneralRegressionModel generalRegressionModel) {
        return visit(((PMMLObject) generalRegressionModel));
    }

    @Override
    public VisitorAction visit(RegressionModel regressionModel) {
        return visit(((PMMLObject) regressionModel));
    }

    @Override
    public VisitorAction visit(RuleSelectionMethod ruleSelectionMethod) {
        return visit(((PMMLObject) ruleSelectionMethod));
    }

    @Override
    public VisitorAction visit(SetPredicate setPredicate) {
        return visit(((PMMLObject) setPredicate));
    }

    @Override
    public VisitorAction visit(Scorecard scorecard) {
        return visit(((PMMLObject) scorecard));
    }

    @Override
    public VisitorAction visit(ChildParent childParent) {
        return visit(((PMMLObject) childParent));
    }

    @Override
    public VisitorAction visit(TextModelNormalization textModelNormalization) {
        return visit(((PMMLObject) textModelNormalization));
    }

    @Override
    public VisitorAction visit(TextModelSimiliarity textModelSimiliarity) {
        return visit(((PMMLObject) textModelSimiliarity));
    }

    @Override
    public VisitorAction visit(TrendExpoSmooth trendExpoSmooth) {
        return visit(((PMMLObject) trendExpoSmooth));
    }

    @Override
    public VisitorAction visit(SeasonalityExpoSmooth seasonalityExpoSmooth) {
        return visit(((PMMLObject) seasonalityExpoSmooth));
    }

    @Override
    public VisitorAction visit(ExponentialSmoothing exponentialSmoothing) {
        return visit(((PMMLObject) exponentialSmoothing));
    }

    @Override
    public VisitorAction visit(TreeModel treeModel) {
        return visit(((PMMLObject) treeModel));
    }

    @Override
    public VisitorAction visit(DataField dataField) {
        return visit(((PMMLObject) dataField));
    }

    @Override
    public VisitorAction visit(DefineFunction defineFunction) {
        return visit(((PMMLObject) defineFunction));
    }

    @Override
    public VisitorAction visit(Extension extension) {
        return visit(((PMMLObject) extension));
    }

    @Override
    public VisitorAction visit(ParameterField parameterField) {
        return visit(((PMMLObject) parameterField));
    }

    @Override
    public VisitorAction visit(Constant constant) {
        return visit(((PMMLObject) constant));
    }

    @Override
    public VisitorAction visit(FieldRef fieldRef) {
        return visit(((PMMLObject) fieldRef));
    }

    @Override
    public VisitorAction visit(NormContinuous normContinuous) {
        return visit(((PMMLObject) normContinuous));
    }

    @Override
    public VisitorAction visit(LinearNorm linearNorm) {
        return visit(((PMMLObject) linearNorm));
    }

    @Override
    public VisitorAction visit(Discretize discretize) {
        return visit(((PMMLObject) discretize));
    }

    @Override
    public VisitorAction visit(DiscretizeBin discretizeBin) {
        return visit(((PMMLObject) discretizeBin));
    }

    @Override
    public VisitorAction visit(MapValues mapValues) {
        return visit(((PMMLObject) mapValues));
    }

    @Override
    public VisitorAction visit(FieldColumnPair fieldColumnPair) {
        return visit(((PMMLObject) fieldColumnPair));
    }

    @Override
    public VisitorAction visit(TableLocator tableLocator) {
        return visit(((PMMLObject) tableLocator));
    }

    @Override
    public VisitorAction visit(InlineTable inlineTable) {
        return visit(((PMMLObject) inlineTable));
    }

    @Override
    public VisitorAction visit(Row row) {
        return visit(((PMMLObject) row));
    }

    @Override
    public VisitorAction visit(TextIndexNormalization textIndexNormalization) {
        return visit(((PMMLObject) textIndexNormalization));
    }

    @Override
    public VisitorAction visit(Apply apply) {
        return visit(((PMMLObject) apply));
    }

    @Override
    public VisitorAction visit(MiningModel miningModel) {
        return visit(((PMMLObject) miningModel));
    }

    @Override
    public VisitorAction visit(MiningSchema miningSchema) {
        return visit(((PMMLObject) miningSchema));
    }

    @Override
    public VisitorAction visit(MiningField miningField) {
        return visit(((PMMLObject) miningField));
    }

    @Override
    public VisitorAction visit(Output output) {
        return visit(((PMMLObject) output));
    }

    @Override
    public VisitorAction visit(Decisions decisions) {
        return visit(((PMMLObject) decisions));
    }

    @Override
    public VisitorAction visit(Decision decision) {
        return visit(((PMMLObject) decision));
    }

    @Override
    public VisitorAction visit(ModelStats modelStats) {
        return visit(((PMMLObject) modelStats));
    }

    @Override
    public VisitorAction visit(Counts counts) {
        return visit(((PMMLObject) counts));
    }

    @Override
    public VisitorAction visit(NumericInfo numericInfo) {
        return visit(((PMMLObject) numericInfo));
    }

    @Override
    public VisitorAction visit(Quantile quantile) {
        return visit(((PMMLObject) quantile));
    }

    @Override
    public VisitorAction visit(DiscrStats discrStats) {
        return visit(((PMMLObject) discrStats));
    }

    @Override
    public VisitorAction visit(ContStats contStats) {
        return visit(((PMMLObject) contStats));
    }

    @Override
    public VisitorAction visit(Anova anova) {
        return visit(((PMMLObject) anova));
    }

    @Override
    public VisitorAction visit(MultivariateStats multivariateStats) {
        return visit(((PMMLObject) multivariateStats));
    }

    @Override
    public VisitorAction visit(MultivariateStat multivariateStat) {
        return visit(((PMMLObject) multivariateStat));
    }

    @Override
    public VisitorAction visit(ModelExplanation modelExplanation) {
        return visit(((PMMLObject) modelExplanation));
    }

    @Override
    public VisitorAction visit(ConfusionMatrix confusionMatrix) {
        return visit(((PMMLObject) confusionMatrix));
    }

    @Override
    public VisitorAction visit(ClassLabels classLabels) {
        return visit(((PMMLObject) classLabels));
    }

    @Override
    public VisitorAction visit(MatCell matCell) {
        return visit(((PMMLObject) matCell));
    }

    @Override
    public VisitorAction visit(LiftData liftData) {
        return visit(((PMMLObject) liftData));
    }

    @Override
    public VisitorAction visit(ModelLiftGraph modelLiftGraph) {
        return visit(((PMMLObject) modelLiftGraph));
    }

    @Override
    public VisitorAction visit(LiftGraph liftGraph) {
        return visit(((PMMLObject) liftGraph));
    }

    @Override
    public VisitorAction visit(XCoordinates xCoordinates) {
        return visit(((PMMLObject) xCoordinates));
    }

    @Override
    public VisitorAction visit(YCoordinates yCoordinates) {
        return visit(((PMMLObject) yCoordinates));
    }

    @Override
    public VisitorAction visit(BoundaryValues boundaryValues) {
        return visit(((PMMLObject) boundaryValues));
    }

    @Override
    public VisitorAction visit(BoundaryValueMeans boundaryValueMeans) {
        return visit(((PMMLObject) boundaryValueMeans));
    }

    @Override
    public VisitorAction visit(OptimumLiftGraph optimumLiftGraph) {
        return visit(((PMMLObject) optimumLiftGraph));
    }

    @Override
    public VisitorAction visit(RandomLiftGraph randomLiftGraph) {
        return visit(((PMMLObject) randomLiftGraph));
    }

    @Override
    public VisitorAction visit(ROC roc) {
        return visit(((PMMLObject) roc));
    }

    @Override
    public VisitorAction visit(ROCGraph rocGraph) {
        return visit(((PMMLObject) rocGraph));
    }

    @Override
    public VisitorAction visit(ClusteringModelQuality clusteringModelQuality) {
        return visit(((PMMLObject) clusteringModelQuality));
    }

    @Override
    public VisitorAction visit(Correlations correlations) {
        return visit(((PMMLObject) correlations));
    }

    @Override
    public VisitorAction visit(CorrelationFields correlationFields) {
        return visit(((PMMLObject) correlationFields));
    }

    @Override
    public VisitorAction visit(CorrelationValues correlationValues) {
        return visit(((PMMLObject) correlationValues));
    }

    @Override
    public VisitorAction visit(CorrelationMethods correlationMethods) {
        return visit(((PMMLObject) correlationMethods));
    }

    @Override
    public VisitorAction visit(Targets targets) {
        return visit(((PMMLObject) targets));
    }

    @Override
    public VisitorAction visit(TargetValue targetValue) {
        return visit(((PMMLObject) targetValue));
    }

    @Override
    public VisitorAction visit(Partition partition) {
        return visit(((PMMLObject) partition));
    }

    @Override
    public VisitorAction visit(LocalTransformations localTransformations) {
        return visit(((PMMLObject) localTransformations));
    }

    @Override
    public VisitorAction visit(DerivedField derivedField) {
        return visit(((PMMLObject) derivedField));
    }

    @Override
    public VisitorAction visit(Regression regression) {
        return visit(((PMMLObject) regression));
    }

    @Override
    public VisitorAction visit(ResultField resultField) {
        return visit(((PMMLObject) resultField));
    }

    @Override
    public VisitorAction visit(RegressionTable regressionTable) {
        return visit(((PMMLObject) regressionTable));
    }

    @Override
    public VisitorAction visit(NumericPredictor numericPredictor) {
        return visit(((PMMLObject) numericPredictor));
    }

    @Override
    public VisitorAction visit(CategoricalPredictor categoricalPredictor) {
        return visit(((PMMLObject) categoricalPredictor));
    }

    @Override
    public VisitorAction visit(PredictorTerm predictorTerm) {
        return visit(((PMMLObject) predictorTerm));
    }

    @Override
    public VisitorAction visit(Node node) {
        return visit(((PMMLObject) node));
    }

    @Override
    public VisitorAction visit(True _true) {
        return visit(((PMMLObject) _true));
    }

    @Override
    public VisitorAction visit(False _false) {
        return visit(((PMMLObject) _false));
    }

    @Override
    public VisitorAction visit(ScoreDistribution scoreDistribution) {
        return visit(((PMMLObject) scoreDistribution));
    }

    @Override
    public VisitorAction visit(Segmentation segmentation) {
        return visit(((PMMLObject) segmentation));
    }

    @Override
    public VisitorAction visit(Segment segment) {
        return visit(((PMMLObject) segment));
    }

    @Override
    public VisitorAction visit(AssociationModel associationModel) {
        return visit(((PMMLObject) associationModel));
    }

    @Override
    public VisitorAction visit(Item item) {
        return visit(((PMMLObject) item));
    }

    @Override
    public VisitorAction visit(Itemset itemset) {
        return visit(((PMMLObject) itemset));
    }

    @Override
    public VisitorAction visit(ItemRef itemRef) {
        return visit(((PMMLObject) itemRef));
    }

    @Override
    public VisitorAction visit(AssociationRule associationRule) {
        return visit(((PMMLObject) associationRule));
    }

    @Override
    public VisitorAction visit(ModelVerification modelVerification) {
        return visit(((PMMLObject) modelVerification));
    }

    @Override
    public VisitorAction visit(VerificationFields verificationFields) {
        return visit(((PMMLObject) verificationFields));
    }

    @Override
    public VisitorAction visit(VerificationField verificationField) {
        return visit(((PMMLObject) verificationField));
    }

    @Override
    public VisitorAction visit(BaselineModel baselineModel) {
        return visit(((PMMLObject) baselineModel));
    }

    @Override
    public VisitorAction visit(TestDistributions testDistributions) {
        return visit(((PMMLObject) testDistributions));
    }

    @Override
    public VisitorAction visit(Baseline baseline) {
        return visit(((PMMLObject) baseline));
    }

    @Override
    public VisitorAction visit(AnyDistribution anyDistribution) {
        return visit(((PMMLObject) anyDistribution));
    }

    @Override
    public VisitorAction visit(GaussianDistribution gaussianDistribution) {
        return visit(((PMMLObject) gaussianDistribution));
    }

    @Override
    public VisitorAction visit(PoissonDistribution poissonDistribution) {
        return visit(((PMMLObject) poissonDistribution));
    }

    @Override
    public VisitorAction visit(UniformDistribution uniformDistribution) {
        return visit(((PMMLObject) uniformDistribution));
    }

    @Override
    public VisitorAction visit(CountTable countTable) {
        return visit(((PMMLObject) countTable));
    }

    @Override
    public VisitorAction visit(Alternate alternate) {
        return visit(((PMMLObject) alternate));
    }

    @Override
    public VisitorAction visit(Euclidean euclidean) {
        return visit(((PMMLObject) euclidean));
    }

    @Override
    public VisitorAction visit(SquaredEuclidean squaredEuclidean) {
        return visit(((PMMLObject) squaredEuclidean));
    }

    @Override
    public VisitorAction visit(Chebychev chebychev) {
        return visit(((PMMLObject) chebychev));
    }

    @Override
    public VisitorAction visit(CityBlock cityBlock) {
        return visit(((PMMLObject) cityBlock));
    }

    @Override
    public VisitorAction visit(Minkowski minkowski) {
        return visit(((PMMLObject) minkowski));
    }

    @Override
    public VisitorAction visit(SimpleMatching simpleMatching) {
        return visit(((PMMLObject) simpleMatching));
    }

    @Override
    public VisitorAction visit(Jaccard jaccard) {
        return visit(((PMMLObject) jaccard));
    }

    @Override
    public VisitorAction visit(Tanimoto tanimoto) {
        return visit(((PMMLObject) tanimoto));
    }

    @Override
    public VisitorAction visit(BinarySimilarity binarySimilarity) {
        return visit(((PMMLObject) binarySimilarity));
    }

    @Override
    public VisitorAction visit(Comparisons comparisons) {
        return visit(((PMMLObject) comparisons));
    }

    @Override
    public VisitorAction visit(CenterFields centerFields) {
        return visit(((PMMLObject) centerFields));
    }

    @Override
    public VisitorAction visit(MissingValueWeights missingValueWeights) {
        return visit(((PMMLObject) missingValueWeights));
    }

    @Override
    public VisitorAction visit(Cluster cluster) {
        return visit(((PMMLObject) cluster));
    }

    @Override
    public VisitorAction visit(KohonenMap kohonenMap) {
        return visit(((PMMLObject) kohonenMap));
    }

    @Override
    public VisitorAction visit(Covariances covariances) {
        return visit(((PMMLObject) covariances));
    }

    @Override
    public VisitorAction visit(ParameterList parameterList) {
        return visit(((PMMLObject) parameterList));
    }

    @Override
    public VisitorAction visit(Parameter parameter) {
        return visit(((PMMLObject) parameter));
    }

    @Override
    public VisitorAction visit(FactorList factorList) {
        return visit(((PMMLObject) factorList));
    }

    @Override
    public VisitorAction visit(Predictor predictor) {
        return visit(((PMMLObject) predictor));
    }

    @Override
    public VisitorAction visit(Categories categories) {
        return visit(((PMMLObject) categories));
    }

    @Override
    public VisitorAction visit(Category category) {
        return visit(((PMMLObject) category));
    }

    @Override
    public VisitorAction visit(CovariateList covariateList) {
        return visit(((PMMLObject) covariateList));
    }

    @Override
    public VisitorAction visit(PPMatrix ppMatrix) {
        return visit(((PMMLObject) ppMatrix));
    }

    @Override
    public VisitorAction visit(PPCell ppCell) {
        return visit(((PMMLObject) ppCell));
    }

    @Override
    public VisitorAction visit(PCovCell pCovCell) {
        return visit(((PMMLObject) pCovCell));
    }

    @Override
    public VisitorAction visit(ParamMatrix paramMatrix) {
        return visit(((PMMLObject) paramMatrix));
    }

    @Override
    public VisitorAction visit(PCell pCell) {
        return visit(((PMMLObject) pCell));
    }

    @Override
    public VisitorAction visit(EventValues eventValues) {
        return visit(((PMMLObject) eventValues));
    }

    @Override
    public VisitorAction visit(BaseCumHazardTables baseCumHazardTables) {
        return visit(((PMMLObject) baseCumHazardTables));
    }

    @Override
    public VisitorAction visit(BaselineStratum baselineStratum) {
        return visit(((PMMLObject) baselineStratum));
    }

    @Override
    public VisitorAction visit(BaselineCell baselineCell) {
        return visit(((PMMLObject) baselineCell));
    }

    @Override
    public VisitorAction visit(NaiveBayesModel naiveBayesModel) {
        return visit(((PMMLObject) naiveBayesModel));
    }

    @Override
    public VisitorAction visit(BayesInputs bayesInputs) {
        return visit(((PMMLObject) bayesInputs));
    }

    @Override
    public VisitorAction visit(BayesInput bayesInput) {
        return visit(((PMMLObject) bayesInput));
    }

    @Override
    public VisitorAction visit(TargetValueStats targetValueStats) {
        return visit(((PMMLObject) targetValueStats));
    }

    @Override
    public VisitorAction visit(TargetValueStat targetValueStat) {
        return visit(((PMMLObject) targetValueStat));
    }

    @Override
    public VisitorAction visit(PairCounts pairCounts) {
        return visit(((PMMLObject) pairCounts));
    }

    @Override
    public VisitorAction visit(TargetValueCounts targetValueCounts) {
        return visit(((PMMLObject) targetValueCounts));
    }

    @Override
    public VisitorAction visit(TargetValueCount targetValueCount) {
        return visit(((PMMLObject) targetValueCount));
    }

    @Override
    public VisitorAction visit(BayesOutput bayesOutput) {
        return visit(((PMMLObject) bayesOutput));
    }

    @Override
    public VisitorAction visit(NearestNeighborModel nearestNeighborModel) {
        return visit(((PMMLObject) nearestNeighborModel));
    }

    @Override
    public VisitorAction visit(TrainingInstances trainingInstances) {
        return visit(((PMMLObject) trainingInstances));
    }

    @Override
    public VisitorAction visit(InstanceFields instanceFields) {
        return visit(((PMMLObject) instanceFields));
    }

    @Override
    public VisitorAction visit(InstanceField instanceField) {
        return visit(((PMMLObject) instanceField));
    }

    @Override
    public VisitorAction visit(KNNInputs knnInputs) {
        return visit(((PMMLObject) knnInputs));
    }

    @Override
    public VisitorAction visit(KNNInput knnInput) {
        return visit(((PMMLObject) knnInput));
    }

    @Override
    public VisitorAction visit(NeuralNetwork neuralNetwork) {
        return visit(((PMMLObject) neuralNetwork));
    }

    @Override
    public VisitorAction visit(NeuralInputs neuralInputs) {
        return visit(((PMMLObject) neuralInputs));
    }

    @Override
    public VisitorAction visit(NeuralInput neuralInput) {
        return visit(((PMMLObject) neuralInput));
    }

    @Override
    public VisitorAction visit(NeuralLayer neuralLayer) {
        return visit(((PMMLObject) neuralLayer));
    }

    @Override
    public VisitorAction visit(Neuron neuron) {
        return visit(((PMMLObject) neuron));
    }

    @Override
    public VisitorAction visit(Connection connection) {
        return visit(((PMMLObject) connection));
    }

    @Override
    public VisitorAction visit(NeuralOutputs neuralOutputs) {
        return visit(((PMMLObject) neuralOutputs));
    }

    @Override
    public VisitorAction visit(NeuralOutput neuralOutput) {
        return visit(((PMMLObject) neuralOutput));
    }

    @Override
    public VisitorAction visit(RuleSetModel ruleSetModel) {
        return visit(((PMMLObject) ruleSetModel));
    }

    @Override
    public VisitorAction visit(RuleSet ruleSet) {
        return visit(((PMMLObject) ruleSet));
    }

    @Override
    public VisitorAction visit(SimpleRule simpleRule) {
        return visit(((PMMLObject) simpleRule));
    }

    @Override
    public VisitorAction visit(CompoundRule compoundRule) {
        return visit(((PMMLObject) compoundRule));
    }

    @Override
    public VisitorAction visit(SequenceModel sequenceModel) {
        return visit(((PMMLObject) sequenceModel));
    }

    @Override
    public VisitorAction visit(Constraints constraints) {
        return visit(((PMMLObject) constraints));
    }

    @Override
    public VisitorAction visit(Sequence sequence) {
        return visit(((PMMLObject) sequence));
    }

    @Override
    public VisitorAction visit(SetReference setReference) {
        return visit(((PMMLObject) setReference));
    }

    @Override
    public VisitorAction visit(Delimiter delimiter) {
        return visit(((PMMLObject) delimiter));
    }

    @Override
    public VisitorAction visit(Time time) {
        return visit(((PMMLObject) time));
    }

    @Override
    public VisitorAction visit(SequenceRule sequenceRule) {
        return visit(((PMMLObject) sequenceRule));
    }

    @Override
    public VisitorAction visit(AntecedentSequence antecedentSequence) {
        return visit(((PMMLObject) antecedentSequence));
    }

    @Override
    public VisitorAction visit(SequenceReference sequenceReference) {
        return visit(((PMMLObject) sequenceReference));
    }

    @Override
    public VisitorAction visit(ConsequentSequence consequentSequence) {
        return visit(((PMMLObject) consequentSequence));
    }

    @Override
    public VisitorAction visit(Characteristics characteristics) {
        return visit(((PMMLObject) characteristics));
    }

    @Override
    public VisitorAction visit(Characteristic characteristic) {
        return visit(((PMMLObject) characteristic));
    }

    @Override
    public VisitorAction visit(Attribute attribute) {
        return visit(((PMMLObject) attribute));
    }

    @Override
    public VisitorAction visit(ComplexPartialScore complexPartialScore) {
        return visit(((PMMLObject) complexPartialScore));
    }

    @Override
    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
        return visit(((PMMLObject) supportVectorMachineModel));
    }

    @Override
    public VisitorAction visit(LinearKernel linearKernel) {
        return visit(((PMMLObject) linearKernel));
    }

    @Override
    public VisitorAction visit(PolynomialKernel polynomialKernel) {
        return visit(((PMMLObject) polynomialKernel));
    }

    @Override
    public VisitorAction visit(RadialBasisKernel radialBasisKernel) {
        return visit(((PMMLObject) radialBasisKernel));
    }

    @Override
    public VisitorAction visit(SigmoidKernel sigmoidKernel) {
        return visit(((PMMLObject) sigmoidKernel));
    }

    @Override
    public VisitorAction visit(VectorDictionary vectorDictionary) {
        return visit(((PMMLObject) vectorDictionary));
    }

    @Override
    public VisitorAction visit(VectorFields vectorFields) {
        return visit(((PMMLObject) vectorFields));
    }

    @Override
    public VisitorAction visit(VectorInstance vectorInstance) {
        return visit(((PMMLObject) vectorInstance));
    }

    @Override
    public VisitorAction visit(RealSparseArray realSparseArray) {
        return visit(((PMMLObject) realSparseArray));
    }

    @Override
    public VisitorAction visit(SupportVectorMachine supportVectorMachine) {
        return visit(((PMMLObject) supportVectorMachine));
    }

    @Override
    public VisitorAction visit(SupportVectors supportVectors) {
        return visit(((PMMLObject) supportVectors));
    }

    @Override
    public VisitorAction visit(SupportVector supportVector) {
        return visit(((PMMLObject) supportVector));
    }

    @Override
    public VisitorAction visit(Coefficients coefficients) {
        return visit(((PMMLObject) coefficients));
    }

    @Override
    public VisitorAction visit(Coefficient coefficient) {
        return visit(((PMMLObject) coefficient));
    }

    @Override
    public VisitorAction visit(TextModel textModel) {
        return visit(((PMMLObject) textModel));
    }

    @Override
    public VisitorAction visit(TextDictionary textDictionary) {
        return visit(((PMMLObject) textDictionary));
    }

    @Override
    public VisitorAction visit(Taxonomy taxonomy) {
        return visit(((PMMLObject) taxonomy));
    }

    @Override
    public VisitorAction visit(TextCorpus textCorpus) {
        return visit(((PMMLObject) textCorpus));
    }

    @Override
    public VisitorAction visit(TextDocument textDocument) {
        return visit(((PMMLObject) textDocument));
    }

    @Override
    public VisitorAction visit(DocumentTermMatrix documentTermMatrix) {
        return visit(((PMMLObject) documentTermMatrix));
    }

    @Override
    public VisitorAction visit(TimeSeriesModel timeSeriesModel) {
        return visit(((PMMLObject) timeSeriesModel));
    }

    @Override
    public VisitorAction visit(TimeSeries timeSeries) {
        return visit(((PMMLObject) timeSeries));
    }

    @Override
    public VisitorAction visit(TimeAnchor timeAnchor) {
        return visit(((PMMLObject) timeAnchor));
    }

    @Override
    public VisitorAction visit(TimeCycle timeCycle) {
        return visit(((PMMLObject) timeCycle));
    }

    @Override
    public VisitorAction visit(TimeException timeException) {
        return visit(((PMMLObject) timeException));
    }

    @Override
    public VisitorAction visit(TimeValue timeValue) {
        return visit(((PMMLObject) timeValue));
    }

    @Override
    public VisitorAction visit(Timestamp timestamp) {
        return visit(((PMMLObject) timestamp));
    }

    @Override
    public VisitorAction visit(SpectralAnalysis spectralAnalysis) {
        return visit(((PMMLObject) spectralAnalysis));
    }

    @Override
    public VisitorAction visit(ARIMA arima) {
        return visit(((PMMLObject) arima));
    }

    @Override
    public VisitorAction visit(Level level) {
        return visit(((PMMLObject) level));
    }

    @Override
    public VisitorAction visit(SeasonalTrendDecomposition seasonalTrendDecomposition) {
        return visit(((PMMLObject) seasonalTrendDecomposition));
    }

    @Override
    public VisitorAction visit(PMML pmml) {
        return visit(((PMMLObject) pmml));
    }

    @Override
    public VisitorAction visit(Header header) {
        return visit(((PMMLObject) header));
    }

    @Override
    public VisitorAction visit(Application application) {
        return visit(((PMMLObject) application));
    }

    @Override
    public VisitorAction visit(Annotation annotation) {
        return visit(((PMMLObject) annotation));
    }

    @Override
    public VisitorAction visit(MiningBuildTask miningBuildTask) {
        return visit(((PMMLObject) miningBuildTask));
    }

    @Override
    public VisitorAction visit(DataDictionary dataDictionary) {
        return visit(((PMMLObject) dataDictionary));
    }

    @Override
    public VisitorAction visit(TransformationDictionary transformationDictionary) {
        return visit(((PMMLObject) transformationDictionary));
    }

    @Override
    public VisitorAction visit(IntSparseArray intSparseArray) {
        return visit(((PMMLObject) intSparseArray));
    }

    @Override
    public VisitorAction visit(FieldValue fieldValue) {
        return visit(((PMMLObject) fieldValue));
    }

    @Override
    public VisitorAction visit(FieldValueCount fieldValueCount) {
        return visit(((PMMLObject) fieldValueCount));
    }

}
