/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;

public class FieldUtil {
    private FieldUtil() {
    }

    public static Set<FieldName> nameSet(Collection<? extends Field> fields) {
        Map<FieldName, ? extends Field> result = FieldUtil.nameMap(fields);
        return result.keySet();
    }

    public static <F extends Field> Map<FieldName, F> nameMap(Collection<? extends F> fields) {
        LinkedHashMap<FieldName, Field> result = new LinkedHashMap<FieldName, Field>();
        for (Field field : fields) {
            FieldName name = field.getName();
            Field previousField = result.put(name, field);
            if (previousField == null) continue;
            throw new IllegalArgumentException("Fields " + FieldUtil.format(field) + " and " + FieldUtil.format(previousField) + " have the same name " + name);
        }
        return result;
    }

    public static <F extends Field> Set<F> selectAll(Collection<? extends F> fields, Set<FieldName> names) {
        return FieldUtil.selectAll(fields, names, false);
    }

    public static <F extends Field> Set<F> selectAll(Collection<? extends F> fields, Set<FieldName> names, boolean allowPartialSelection) {
        Map<FieldName, F> result = FieldUtil.nameMap(fields);
        if (!allowPartialSelection && !result.keySet().containsAll(names)) {
            LinkedHashSet<FieldName> unmatchedNames = new LinkedHashSet<FieldName>(names);
            unmatchedNames.removeAll(result.keySet());
            throw new IllegalArgumentException("Empty selection for names " + unmatchedNames);
        }
        result.keySet().retainAll(names);
        return new LinkedHashSet<F>(result.values());
    }

    private static String format(Field field) {
        return String.valueOf(field);
    }
}

