/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Interval;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.Value;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "intervals", "values"})
@XmlRootElement(name="DataField", namespace="http://www.dmg.org/PMML-4_2")
public class DataField
extends TypeDefinitionField
implements HasExtensions {
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name="displayName")
    private String displayName;
    @XmlAttribute(name="optype", required=true)
    private OpType opType;
    @XmlAttribute(name="dataType", required=true)
    private DataType dataType;
    @XmlAttribute(name="taxonomy")
    private String taxonomy;
    @XmlAttribute(name="isCyclic")
    private Cyclic cyclic;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="Interval", namespace="http://www.dmg.org/PMML-4_2")
    private List<Interval> intervals;
    @XmlElement(name="Value", namespace="http://www.dmg.org/PMML-4_2")
    private List<Value> values;

    public DataField() {
    }

    public DataField(FieldName name, OpType opType, DataType dataType) {
        this.name = name;
        this.opType = opType;
        this.dataType = dataType;
    }

    @Override
    public FieldName getName() {
        return this.name;
    }

    @Override
    public DataField setName(FieldName name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public DataField setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public OpType getOpType() {
        return this.opType;
    }

    @Override
    public DataField setOpType(OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public DataField setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public DataField setTaxonomy(String taxonomy) {
        this.taxonomy = taxonomy;
        return this;
    }

    public Cyclic getCyclic() {
        if (this.cyclic == null) {
            return Cyclic.ZERO;
        }
        return this.cyclic;
    }

    public DataField setCyclic(Cyclic cyclic) {
        this.cyclic = cyclic;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Interval> getIntervals() {
        if (this.intervals == null) {
            this.intervals = new ArrayList<Interval>();
        }
        return this.intervals;
    }

    @Override
    public List<Value> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<Value>();
        }
        return this.values;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public DataField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasIntervals() {
        return this.intervals != null && this.intervals.size() > 0;
    }

    public DataField addIntervals(Interval ... intervals) {
        this.getIntervals().addAll(Arrays.asList(intervals));
        return this;
    }

    public boolean hasValues() {
        return this.values != null && this.values.size() > 0;
    }

    public DataField addValues(Value ... values) {
        this.getValues().addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE && this.hasIntervals()) {
            status = PMMLObject.traverse(visitor, this.getIntervals());
        }
        if (status == VisitorAction.CONTINUE && this.hasValues()) {
            status = PMMLObject.traverse(visitor, this.getValues());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Cyclic {
        ZERO("0"),
        ONE("1");

        private final String value;

        private Cyclic(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Cyclic fromValue(String v) {
            for (Cyclic c : Cyclic.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

