
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ROCGraph"/>
 *       &lt;/sequence>
 *       &lt;attribute name="positiveTargetFieldValue" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="positiveTargetFieldDisplayValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="negativeTargetFieldValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="negativeTargetFieldDisplayValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "rocGraph"
})
@XmlRootElement(name = "ROC", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class ROC
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "positiveTargetFieldValue", required = true)
    private String positiveTargetFieldValue;
    @XmlAttribute(name = "positiveTargetFieldDisplayValue")
    private String positiveTargetFieldDisplayValue;
    @XmlAttribute(name = "negativeTargetFieldValue")
    private String negativeTargetFieldValue;
    @XmlAttribute(name = "negativeTargetFieldDisplayValue")
    private String negativeTargetFieldDisplayValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "ROCGraph", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private ROCGraph rocGraph;

    public ROC() {
        super();
    }

    public ROC(final String positiveTargetFieldValue, final ROCGraph rocGraph) {
        super();
        this.positiveTargetFieldValue = positiveTargetFieldValue;
        this.rocGraph = rocGraph;
    }

    /**
     * Gets the value of the positiveTargetFieldValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPositiveTargetFieldValue() {
        return positiveTargetFieldValue;
    }

    /**
     * Sets the value of the positiveTargetFieldValue property.
     * 
     * @param positiveTargetFieldValue
     *     allowed object is
     *     {@link String }
     *     
     */
    public ROC setPositiveTargetFieldValue(String positiveTargetFieldValue) {
        this.positiveTargetFieldValue = positiveTargetFieldValue;
        return this;
    }

    /**
     * Gets the value of the positiveTargetFieldDisplayValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPositiveTargetFieldDisplayValue() {
        return positiveTargetFieldDisplayValue;
    }

    /**
     * Sets the value of the positiveTargetFieldDisplayValue property.
     * 
     * @param positiveTargetFieldDisplayValue
     *     allowed object is
     *     {@link String }
     *     
     */
    public ROC setPositiveTargetFieldDisplayValue(String positiveTargetFieldDisplayValue) {
        this.positiveTargetFieldDisplayValue = positiveTargetFieldDisplayValue;
        return this;
    }

    /**
     * Gets the value of the negativeTargetFieldValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNegativeTargetFieldValue() {
        return negativeTargetFieldValue;
    }

    /**
     * Sets the value of the negativeTargetFieldValue property.
     * 
     * @param negativeTargetFieldValue
     *     allowed object is
     *     {@link String }
     *     
     */
    public ROC setNegativeTargetFieldValue(String negativeTargetFieldValue) {
        this.negativeTargetFieldValue = negativeTargetFieldValue;
        return this;
    }

    /**
     * Gets the value of the negativeTargetFieldDisplayValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNegativeTargetFieldDisplayValue() {
        return negativeTargetFieldDisplayValue;
    }

    /**
     * Sets the value of the negativeTargetFieldDisplayValue property.
     * 
     * @param negativeTargetFieldDisplayValue
     *     allowed object is
     *     {@link String }
     *     
     */
    public ROC setNegativeTargetFieldDisplayValue(String negativeTargetFieldDisplayValue) {
        this.negativeTargetFieldDisplayValue = negativeTargetFieldDisplayValue;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the rocGraph property.
     * 
     * @return
     *     possible object is
     *     {@link ROCGraph }
     *     
     */
    public ROCGraph getROCGraph() {
        return rocGraph;
    }

    /**
     * Sets the value of the rocGraph property.
     * 
     * @param rocGraph
     *     allowed object is
     *     {@link ROCGraph }
     *     
     */
    public ROC setROCGraph(ROCGraph rocGraph) {
        this.rocGraph = rocGraph;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ROC addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getROCGraph());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
