
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}VectorFields"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}VectorInstance" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfVectors" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "vectorFields",
    "vectorInstances"
})
@XmlRootElement(name = "VectorDictionary", namespace = "http://www.dmg.org/PMML-4_2")
public class VectorDictionary
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "numberOfVectors")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer numberOfVectors;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "VectorFields", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    @Added(Version.PMML_3_1)
    private VectorFields vectorFields;
    @XmlElement(name = "VectorInstance", namespace = "http://www.dmg.org/PMML-4_2")
    private List<VectorInstance> vectorInstances;

    public VectorDictionary() {
        super();
    }

    public VectorDictionary(final VectorFields vectorFields) {
        super();
        this.vectorFields = vectorFields;
    }

    /**
     * Gets the value of the numberOfVectors property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfVectors() {
        return numberOfVectors;
    }

    /**
     * Sets the value of the numberOfVectors property.
     * 
     * @param numberOfVectors
     *     allowed object is
     *     {@link String }
     *     
     */
    public VectorDictionary setNumberOfVectors(Integer numberOfVectors) {
        this.numberOfVectors = numberOfVectors;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the vectorFields property.
     * 
     * @return
     *     possible object is
     *     {@link VectorFields }
     *     
     */
    public VectorFields getVectorFields() {
        return vectorFields;
    }

    /**
     * Sets the value of the vectorFields property.
     * 
     * @param vectorFields
     *     allowed object is
     *     {@link VectorFields }
     *     
     */
    public VectorDictionary setVectorFields(VectorFields vectorFields) {
        this.vectorFields = vectorFields;
        return this;
    }

    /**
     * Gets the value of the vectorInstances property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the vectorInstances property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getVectorInstances().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VectorInstance }
     * 
     * 
     */
    public List<VectorInstance> getVectorInstances() {
        if (vectorInstances == null) {
            vectorInstances = new ArrayList<VectorInstance>();
        }
        return this.vectorInstances;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public VectorDictionary addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasVectorInstances() {
        return ((this.vectorInstances!= null)&&(this.vectorInstances.size()> 0));
    }

    public VectorDictionary addVectorInstances(VectorInstance... vectorInstances) {
        getVectorInstances().addAll(Arrays.asList(vectorInstances));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getVectorFields());
        }
        if ((status == VisitorAction.CONTINUE)&&hasVectorInstances()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getVectorInstances());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
