/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="VerificationField", namespace="http://www.dmg.org/PMML-4_2")
public class VerificationField
extends PMMLObject
implements HasExtensions,
Indexable<FieldName> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name="column")
    private String column;
    @XmlAttribute(name="precision")
    private Double precision;
    @XmlAttribute(name="zeroThreshold")
    private Double zeroThreshold;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public VerificationField() {
    }

    public VerificationField(FieldName field) {
        this.field = field;
    }

    public FieldName getField() {
        return this.field;
    }

    public VerificationField setField(FieldName field) {
        this.field = field;
        return this;
    }

    public String getColumn() {
        return this.column;
    }

    public VerificationField setColumn(String column) {
        this.column = column;
        return this;
    }

    public Double getPrecision() {
        if (this.precision == null) {
            return 1.0E-6;
        }
        return this.precision;
    }

    public VerificationField setPrecision(Double precision) {
        this.precision = precision;
        return this;
    }

    public Double getZeroThreshold() {
        if (this.zeroThreshold == null) {
            return 1.0E-16;
        }
        return this.zeroThreshold;
    }

    public VerificationField setZeroThreshold(Double zeroThreshold) {
        this.zeroThreshold = zeroThreshold;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public FieldName getKey() {
        return this.getField();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public VerificationField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

