/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.dmg.pmml.Visitable;
import org.jpmml.model.FieldUtil;
import org.jpmml.model.visitors.FieldDependencyResolver;
import org.jpmml.model.visitors.FieldReferenceFinder;
import org.jpmml.model.visitors.FieldResolver;

public class MiningSchemaCleaner
extends FieldResolver {
    private FieldDependencyResolver fieldDependencyResolver = null;

    @Override
    public void applyTo(Visitable visitable) {
        FieldDependencyResolver fieldDependencyResolver = new FieldDependencyResolver();
        fieldDependencyResolver.applyTo(visitable);
        this.setFieldDependencyResolver(fieldDependencyResolver);
        super.applyTo(visitable);
    }

    @Override
    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof MiningModel) {
            MiningModel miningModel = (MiningModel)parent;
            Set<FieldName> activeFieldNames = this.processMiningModel(miningModel);
            this.clean(miningModel, activeFieldNames);
        } else if (parent instanceof Model) {
            Model model = (Model)parent;
            Set<FieldName> activeFieldNames = this.processModel(model);
            this.clean(model, activeFieldNames);
        }
        return parent;
    }

    private Set<FieldName> processMiningModel(MiningModel miningModel) {
        Set<Field> modelFields;
        LinkedHashSet<FieldName> activeFieldNames = new LinkedHashSet<FieldName>();
        Segmentation segmentation = miningModel.getSegmentation();
        List<Segment> segments = segmentation.getSegments();
        for (Segment segment : segments) {
            Model model;
            Predicate predicate = segment.getPredicate();
            if (predicate != null) {
                FieldReferenceFinder fieldReferenceFinder = new FieldReferenceFinder();
                fieldReferenceFinder.applyTo(predicate);
                activeFieldNames.addAll(fieldReferenceFinder.getFieldNames());
            }
            if ((model = segment.getModel()) == null) continue;
            MiningSchema miningSchema = model.getMiningSchema();
            List<MiningField> miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                FieldUsageType fieldUsage = miningField.getUsageType();
                switch (fieldUsage) {
                    case ACTIVE: {
                        activeFieldNames.add(name);
                        break;
                    }
                }
            }
        }
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                modelFields = this.getFields(miningModel, segmentation);
                break;
            }
            default: {
                modelFields = this.getModelFields(miningModel);
            }
        }
        Set<Field> activeFields = FieldUtil.selectAll(modelFields, activeFieldNames);
        return this.processModel(miningModel, activeFields);
    }

    private Set<FieldName> processModel(Model model) {
        FieldReferenceFinder fieldReferenceFinder = new FieldReferenceFinder();
        fieldReferenceFinder.applyTo(model);
        Set<Field> modelFields = this.getModelFields(model);
        Set<Field> activeFields = FieldUtil.selectAll(modelFields, fieldReferenceFinder.getFieldNames());
        return this.processModel(model, activeFields);
    }

    private Set<Field> getModelFields(Model model) {
        Output output = model.getOutput();
        if (output != null) {
            return this.getFields(model, output);
        }
        return this.getFields(model);
    }

    private Set<FieldName> processModel(Model model, Set<Field> activeFields) {
        Output output;
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        fieldDependencyResolver.expand(activeFields);
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            activeFields.removeAll(localTransformations.getDerivedFields());
        }
        if ((output = model.getOutput()) != null && output.hasOutputFields()) {
            activeFields.removeAll(output.getOutputFields());
        }
        return FieldUtil.nameSet(activeFields);
    }

    private void clean(Model model, Set<FieldName> activeFieldNames) {
        MiningSchema miningSchema = model.getMiningSchema();
        if (miningSchema.hasMiningFields()) {
            this.clean(miningSchema.getMiningFields(), activeFieldNames);
        }
    }

    private void clean(List<MiningField> miningFields, Set<FieldName> activeFieldNames) {
        Iterator<MiningField> it = miningFields.iterator();
        while (it.hasNext()) {
            MiningField miningField = it.next();
            FieldName name = miningField.getName();
            FieldUsageType fieldUsage = miningField.getUsageType();
            switch (fieldUsage) {
                case ACTIVE: {
                    if (activeFieldNames.contains(name)) break;
                    it.remove();
                    break;
                }
            }
        }
    }

    private FieldDependencyResolver getFieldDependencyResolver() {
        return this.fieldDependencyResolver;
    }

    private void setFieldDependencyResolver(FieldDependencyResolver fieldDependencyResolver) {
        this.fieldDependencyResolver = fieldDependencyResolver;
    }
}

