
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="function" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="count"/>
 *             &lt;enumeration value="sum"/>
 *             &lt;enumeration value="average"/>
 *             &lt;enumeration value="min"/>
 *             &lt;enumeration value="max"/>
 *             &lt;enumeration value="multiset"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="groupField" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="sqlWhere" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_3")
public class Aggregate
    extends Expression
    implements HasExtensions
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "function", required = true)
    private Aggregate.Function function;
    @XmlAttribute(name = "groupField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName groupField;
    @XmlAttribute(name = "sqlWhere")
    private String sqlWhere;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;

    public Aggregate() {
        super();
    }

    public Aggregate(final FieldName field, final Aggregate.Function function) {
        super();
        this.field = field;
        this.function = function;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public Aggregate setField(FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the function property.
     * 
     * @return
     *     possible object is
     *     {@link Aggregate.Function }
     *     
     */
    public Aggregate.Function getFunction() {
        return function;
    }

    /**
     * Sets the value of the function property.
     * 
     * @param function
     *     allowed object is
     *     {@link Aggregate.Function }
     *     
     */
    public Aggregate setFunction(Aggregate.Function function) {
        this.function = function;
        return this;
    }

    /**
     * Gets the value of the groupField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getGroupField() {
        return groupField;
    }

    /**
     * Sets the value of the groupField property.
     * 
     * @param groupField
     *     allowed object is
     *     {@link String }
     *     
     */
    public Aggregate setGroupField(FieldName groupField) {
        this.groupField = groupField;
        return this;
    }

    /**
     * Gets the value of the sqlWhere property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSqlWhere() {
        return sqlWhere;
    }

    /**
     * Sets the value of the sqlWhere property.
     * 
     * @param sqlWhere
     *     allowed object is
     *     {@link String }
     *     
     */
    public Aggregate setSqlWhere(String sqlWhere) {
        this.sqlWhere = sqlWhere;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Aggregate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="count"/>
     *     &lt;enumeration value="sum"/>
     *     &lt;enumeration value="average"/>
     *     &lt;enumeration value="min"/>
     *     &lt;enumeration value="max"/>
     *     &lt;enumeration value="multiset"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Function {

        @XmlEnumValue("count")
        COUNT("count"),
        @XmlEnumValue("sum")
        SUM("sum"),
        @XmlEnumValue("average")
        AVERAGE("average"),
        @XmlEnumValue("min")
        MIN("min"),
        @XmlEnumValue("max")
        MAX("max"),
        @XmlEnumValue("multiset")
        MULTISET("multiset");
        private final String value;

        Function(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Aggregate.Function fromValue(String v) {
            for (Aggregate.Function c: Aggregate.Function.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
