
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ConfusionMatrix" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LiftData" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ROC" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="targetField" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="dataName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="dataUsage" default="training">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="training"/>
 *             &lt;enumeration value="test"/>
 *             &lt;enumeration value="validation"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="meanError" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="meanAbsoluteError" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="meanSquaredError" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="rootMeanSquaredError" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="r-squared" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="adj-r-squared" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="sumSquaredError" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="sumSquaredRegression" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="numOfRecords" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="numOfRecordsWeighted" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="numOfPredictors" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="degreesOfFreedom" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="fStatistic" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="AIC" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="BIC" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="AICc" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "confusionMatrix",
    "liftDatas",
    "roc"
})
@XmlRootElement(name = "PredictiveModelQuality", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_0)
public class PredictiveModelQuality
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "targetField", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName targetField;
    @XmlAttribute(name = "dataName")
    private String dataName;
    @XmlAttribute(name = "dataUsage")
    private PredictiveModelQuality.DataUsage dataUsage;
    @XmlAttribute(name = "meanError")
    private Double meanError;
    @XmlAttribute(name = "meanAbsoluteError")
    private Double meanAbsoluteError;
    @XmlAttribute(name = "meanSquaredError")
    private Double meanSquaredError;
    @XmlAttribute(name = "rootMeanSquaredError")
    @Added(Version.PMML_4_1)
    private Double rootMeanSquaredError;
    @XmlAttribute(name = "r-squared")
    private Double rSquared;
    @XmlAttribute(name = "adj-r-squared")
    @Added(Version.PMML_4_1)
    private Double adjRSquared;
    @XmlAttribute(name = "sumSquaredError")
    @Added(Version.PMML_4_1)
    private Double sumSquaredError;
    @XmlAttribute(name = "sumSquaredRegression")
    @Added(Version.PMML_4_1)
    private Double sumSquaredRegression;
    @XmlAttribute(name = "numOfRecords")
    @Added(Version.PMML_4_1)
    private Double numOfRecords;
    @XmlAttribute(name = "numOfRecordsWeighted")
    @Added(Version.PMML_4_1)
    private Double numOfRecordsWeighted;
    @XmlAttribute(name = "numOfPredictors")
    @Added(Version.PMML_4_1)
    private Double numOfPredictors;
    @XmlAttribute(name = "degreesOfFreedom")
    @Added(Version.PMML_4_1)
    private Double degreesOfFreedom;
    @XmlAttribute(name = "fStatistic")
    @Added(Version.PMML_4_1)
    private Double fStatistic;
    @XmlAttribute(name = "AIC")
    @Added(Version.PMML_4_1)
    private Double aic;
    @XmlAttribute(name = "BIC")
    @Added(Version.PMML_4_1)
    private Double bic;
    @XmlAttribute(name = "AICc")
    @Added(Version.PMML_4_1)
    private Double aiCc;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "ConfusionMatrix", namespace = "http://www.dmg.org/PMML-4_3")
    private ConfusionMatrix confusionMatrix;
    @XmlElement(name = "LiftData", namespace = "http://www.dmg.org/PMML-4_3")
    private List<LiftData> liftDatas;
    @XmlElement(name = "ROC", namespace = "http://www.dmg.org/PMML-4_3")
    private ROC roc;

    public PredictiveModelQuality() {
        super();
    }

    public PredictiveModelQuality(final FieldName targetField) {
        super();
        this.targetField = targetField;
    }

    /**
     * Gets the value of the targetField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTargetField() {
        return targetField;
    }

    /**
     * Sets the value of the targetField property.
     * 
     * @param targetField
     *     allowed object is
     *     {@link String }
     *     
     */
    public PredictiveModelQuality setTargetField(FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    /**
     * Gets the value of the dataName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDataName() {
        return dataName;
    }

    /**
     * Sets the value of the dataName property.
     * 
     * @param dataName
     *     allowed object is
     *     {@link String }
     *     
     */
    public PredictiveModelQuality setDataName(String dataName) {
        this.dataName = dataName;
        return this;
    }

    /**
     * Gets the value of the dataUsage property.
     * 
     * @return
     *     possible object is
     *     {@link PredictiveModelQuality.DataUsage }
     *     
     */
    public PredictiveModelQuality.DataUsage getDataUsage() {
        if (dataUsage == null) {
            return PredictiveModelQuality.DataUsage.TRAINING;
        } else {
            return dataUsage;
        }
    }

    /**
     * Sets the value of the dataUsage property.
     * 
     * @param dataUsage
     *     allowed object is
     *     {@link PredictiveModelQuality.DataUsage }
     *     
     */
    public PredictiveModelQuality setDataUsage(PredictiveModelQuality.DataUsage dataUsage) {
        this.dataUsage = dataUsage;
        return this;
    }

    /**
     * Gets the value of the meanError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMeanError() {
        return meanError;
    }

    /**
     * Sets the value of the meanError property.
     * 
     * @param meanError
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setMeanError(Double meanError) {
        this.meanError = meanError;
        return this;
    }

    /**
     * Gets the value of the meanAbsoluteError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMeanAbsoluteError() {
        return meanAbsoluteError;
    }

    /**
     * Sets the value of the meanAbsoluteError property.
     * 
     * @param meanAbsoluteError
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setMeanAbsoluteError(Double meanAbsoluteError) {
        this.meanAbsoluteError = meanAbsoluteError;
        return this;
    }

    /**
     * Gets the value of the meanSquaredError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMeanSquaredError() {
        return meanSquaredError;
    }

    /**
     * Sets the value of the meanSquaredError property.
     * 
     * @param meanSquaredError
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setMeanSquaredError(Double meanSquaredError) {
        this.meanSquaredError = meanSquaredError;
        return this;
    }

    /**
     * Gets the value of the rootMeanSquaredError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRootMeanSquaredError() {
        return rootMeanSquaredError;
    }

    /**
     * Sets the value of the rootMeanSquaredError property.
     * 
     * @param rootMeanSquaredError
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setRootMeanSquaredError(Double rootMeanSquaredError) {
        this.rootMeanSquaredError = rootMeanSquaredError;
        return this;
    }

    /**
     * Gets the value of the rSquared property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRSquared() {
        return rSquared;
    }

    /**
     * Sets the value of the rSquared property.
     * 
     * @param rSquared
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setRSquared(Double rSquared) {
        this.rSquared = rSquared;
        return this;
    }

    /**
     * Gets the value of the adjRSquared property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAdjRSquared() {
        return adjRSquared;
    }

    /**
     * Sets the value of the adjRSquared property.
     * 
     * @param adjRSquared
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setAdjRSquared(Double adjRSquared) {
        this.adjRSquared = adjRSquared;
        return this;
    }

    /**
     * Gets the value of the sumSquaredError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getSumSquaredError() {
        return sumSquaredError;
    }

    /**
     * Sets the value of the sumSquaredError property.
     * 
     * @param sumSquaredError
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setSumSquaredError(Double sumSquaredError) {
        this.sumSquaredError = sumSquaredError;
        return this;
    }

    /**
     * Gets the value of the sumSquaredRegression property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getSumSquaredRegression() {
        return sumSquaredRegression;
    }

    /**
     * Sets the value of the sumSquaredRegression property.
     * 
     * @param sumSquaredRegression
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setSumSquaredRegression(Double sumSquaredRegression) {
        this.sumSquaredRegression = sumSquaredRegression;
        return this;
    }

    /**
     * Gets the value of the numOfRecords property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getNumOfRecords() {
        return numOfRecords;
    }

    /**
     * Sets the value of the numOfRecords property.
     * 
     * @param numOfRecords
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setNumOfRecords(Double numOfRecords) {
        this.numOfRecords = numOfRecords;
        return this;
    }

    /**
     * Gets the value of the numOfRecordsWeighted property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getNumOfRecordsWeighted() {
        return numOfRecordsWeighted;
    }

    /**
     * Sets the value of the numOfRecordsWeighted property.
     * 
     * @param numOfRecordsWeighted
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setNumOfRecordsWeighted(Double numOfRecordsWeighted) {
        this.numOfRecordsWeighted = numOfRecordsWeighted;
        return this;
    }

    /**
     * Gets the value of the numOfPredictors property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getNumOfPredictors() {
        return numOfPredictors;
    }

    /**
     * Sets the value of the numOfPredictors property.
     * 
     * @param numOfPredictors
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setNumOfPredictors(Double numOfPredictors) {
        this.numOfPredictors = numOfPredictors;
        return this;
    }

    /**
     * Gets the value of the degreesOfFreedom property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getDegreesOfFreedom() {
        return degreesOfFreedom;
    }

    /**
     * Sets the value of the degreesOfFreedom property.
     * 
     * @param degreesOfFreedom
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setDegreesOfFreedom(Double degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
        return this;
    }

    /**
     * Gets the value of the fStatistic property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getFStatistic() {
        return fStatistic;
    }

    /**
     * Sets the value of the fStatistic property.
     * 
     * @param fStatistic
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setFStatistic(Double fStatistic) {
        this.fStatistic = fStatistic;
        return this;
    }

    /**
     * Gets the value of the aic property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAIC() {
        return aic;
    }

    /**
     * Sets the value of the aic property.
     * 
     * @param aic
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setAIC(Double aic) {
        this.aic = aic;
        return this;
    }

    /**
     * Gets the value of the bic property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getBIC() {
        return bic;
    }

    /**
     * Sets the value of the bic property.
     * 
     * @param bic
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setBIC(Double bic) {
        this.bic = bic;
        return this;
    }

    /**
     * Gets the value of the aiCc property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAICc() {
        return aiCc;
    }

    /**
     * Sets the value of the aiCc property.
     * 
     * @param aiCc
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setAICc(Double aiCc) {
        this.aiCc = aiCc;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the confusionMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link ConfusionMatrix }
     *     
     */
    public ConfusionMatrix getConfusionMatrix() {
        return confusionMatrix;
    }

    /**
     * Sets the value of the confusionMatrix property.
     * 
     * @param confusionMatrix
     *     allowed object is
     *     {@link ConfusionMatrix }
     *     
     */
    public PredictiveModelQuality setConfusionMatrix(ConfusionMatrix confusionMatrix) {
        this.confusionMatrix = confusionMatrix;
        return this;
    }

    /**
     * Gets the value of the liftDatas property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the liftDatas property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLiftDatas().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LiftData }
     * 
     * 
     */
    public List<LiftData> getLiftDatas() {
        if (liftDatas == null) {
            liftDatas = new ArrayList<LiftData>();
        }
        return this.liftDatas;
    }

    /**
     * Gets the value of the roc property.
     * 
     * @return
     *     possible object is
     *     {@link ROC }
     *     
     */
    public ROC getROC() {
        return roc;
    }

    /**
     * Sets the value of the roc property.
     * 
     * @param roc
     *     allowed object is
     *     {@link ROC }
     *     
     */
    public PredictiveModelQuality setROC(ROC roc) {
        this.roc = roc;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public PredictiveModelQuality addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasLiftDatas() {
        return ((this.liftDatas!= null)&&(this.liftDatas.size()> 0));
    }

    public PredictiveModelQuality addLiftDatas(LiftData... liftDatas) {
        getLiftDatas().addAll(Arrays.asList(liftDatas));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getConfusionMatrix());
            }
            if ((status == VisitorAction.CONTINUE)&&hasLiftDatas()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLiftDatas());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getROC());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="training"/>
     *     &lt;enumeration value="test"/>
     *     &lt;enumeration value="validation"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum DataUsage {

        @XmlEnumValue("training")
        TRAINING("training"),
        @XmlEnumValue("test")
        TEST("test"),
        @XmlEnumValue("validation")
        VALIDATION("validation");
        private final String value;

        DataUsage(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static PredictiveModelQuality.DataUsage fromValue(String v) {
            for (PredictiveModelQuality.DataUsage c: PredictiveModelQuality.DataUsage.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
