
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Version;


/**
 * <p>Java class for RESULT-FEATURE.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="RESULT-FEATURE">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="predictedValue"/>
 *     &lt;enumeration value="predictedDisplayValue"/>
 *     &lt;enumeration value="transformedValue"/>
 *     &lt;enumeration value="decision"/>
 *     &lt;enumeration value="probability"/>
 *     &lt;enumeration value="affinity"/>
 *     &lt;enumeration value="residual"/>
 *     &lt;enumeration value="standardError"/>
 *     &lt;enumeration value="clusterId"/>
 *     &lt;enumeration value="clusterAffinity"/>
 *     &lt;enumeration value="entityId"/>
 *     &lt;enumeration value="entityAffinity"/>
 *     &lt;enumeration value="warning"/>
 *     &lt;enumeration value="ruleValue"/>
 *     &lt;enumeration value="reasonCode"/>
 *     &lt;enumeration value="antecedent"/>
 *     &lt;enumeration value="consequent"/>
 *     &lt;enumeration value="rule"/>
 *     &lt;enumeration value="ruleId"/>
 *     &lt;enumeration value="confidence"/>
 *     &lt;enumeration value="support"/>
 *     &lt;enumeration value="lift"/>
 *     &lt;enumeration value="leverage"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "RESULT-FEATURE", namespace = "http://www.dmg.org/PMML-4_3")
@XmlEnum
public enum ResultFeature {

    @XmlEnumValue("predictedValue")
    PREDICTED_VALUE("predictedValue"),
    @XmlEnumValue("predictedDisplayValue")
    PREDICTED_DISPLAY_VALUE("predictedDisplayValue"),
    @XmlEnumValue("transformedValue")
    @Added(Version.PMML_4_1)
    TRANSFORMED_VALUE("transformedValue"),
    @XmlEnumValue("decision")
    @Added(Version.PMML_4_1)
    DECISION("decision"),
    @XmlEnumValue("probability")
    PROBABILITY("probability"),
    @XmlEnumValue("affinity")
    @Added(Version.PMML_4_1)
    AFFINITY("affinity"),
    @XmlEnumValue("residual")
    RESIDUAL("residual"),
    @XmlEnumValue("standardError")
    STANDARD_ERROR("standardError"),
    @XmlEnumValue("clusterId")
    @Deprecated(Version.PMML_4_1)
    CLUSTER_ID("clusterId"),
    @XmlEnumValue("clusterAffinity")
    @Deprecated(Version.PMML_4_1)
    CLUSTER_AFFINITY("clusterAffinity"),
    @XmlEnumValue("entityId")
    @Added(Version.PMML_3_2)
    ENTITY_ID("entityId"),
    @XmlEnumValue("entityAffinity")
    @Added(Version.PMML_3_2)
    @Deprecated(Version.PMML_4_1)
    ENTITY_AFFINITY("entityAffinity"),
    @XmlEnumValue("warning")
    WARNING("warning"),
    @XmlEnumValue("ruleValue")
    @Added(Version.PMML_4_0)
    @Deprecated(Version.PMML_4_2)
    RULE_VALUE("ruleValue"),
    @XmlEnumValue("reasonCode")
    @Added(Version.PMML_4_1)
    REASON_CODE("reasonCode"),
    @XmlEnumValue("antecedent")
    @Added(Version.PMML_4_2)
    ANTECEDENT("antecedent"),
    @XmlEnumValue("consequent")
    @Added(Version.PMML_4_2)
    CONSEQUENT("consequent"),
    @XmlEnumValue("rule")
    @Added(Version.PMML_4_2)
    RULE("rule"),
    @XmlEnumValue("ruleId")
    @Added(Version.PMML_4_2)
    @Deprecated(Version.PMML_4_2)
    RULE_ID("ruleId"),
    @XmlEnumValue("confidence")
    @Added(Version.PMML_4_2)
    CONFIDENCE("confidence"),
    @XmlEnumValue("support")
    @Added(Version.PMML_4_2)
    SUPPORT("support"),
    @XmlEnumValue("lift")
    @Added(Version.PMML_4_2)
    LIFT("lift"),
    @XmlEnumValue("leverage")
    @Added(Version.PMML_4_2)
    LEVERAGE("leverage");
    private final String value;

    ResultFeature(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ResultFeature fromValue(String v) {
        for (ResultFeature c: ResultFeature.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
