
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Array;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Partition;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}KohonenMap" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_3}NUM-ARRAY" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Partition" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Covariances" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="size" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "kohonenMap",
    "array",
    "partition",
    "covariances"
})
@XmlRootElement(name = "Cluster", namespace = "http://www.dmg.org/PMML-4_3")
public class Cluster
    extends Entity
    implements HasExtensions
{

    @XmlAttribute(name = "id")
    @Added(Version.PMML_4_1)
    private String id;
    @XmlAttribute(name = "name")
    private String name;
    @XmlAttribute(name = "size")
    private Integer size;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "KohonenMap", namespace = "http://www.dmg.org/PMML-4_3")
    private KohonenMap kohonenMap;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    private Array array;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_3")
    private Partition partition;
    @XmlElement(name = "Covariances", namespace = "http://www.dmg.org/PMML-4_3")
    private Covariances covariances;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param id
     *     allowed object is
     *     {@link String }
     *     
     */
    public Cluster setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param name
     *     allowed object is
     *     {@link String }
     *     
     */
    public Cluster setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Gets the value of the size property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getSize() {
        return size;
    }

    /**
     * Sets the value of the size property.
     * 
     * @param size
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public Cluster setSize(Integer size) {
        this.size = size;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the kohonenMap property.
     * 
     * @return
     *     possible object is
     *     {@link KohonenMap }
     *     
     */
    public KohonenMap getKohonenMap() {
        return kohonenMap;
    }

    /**
     * Sets the value of the kohonenMap property.
     * 
     * @param kohonenMap
     *     allowed object is
     *     {@link KohonenMap }
     *     
     */
    public Cluster setKohonenMap(KohonenMap kohonenMap) {
        this.kohonenMap = kohonenMap;
        return this;
    }

    /**
     * Gets the value of the array property.
     * 
     * @return
     *     possible object is
     *     {@link Array }
     *     
     */
    public Array getArray() {
        return array;
    }

    /**
     * Sets the value of the array property.
     * 
     * @param array
     *     allowed object is
     *     {@link Array }
     *     
     */
    public Cluster setArray(Array array) {
        this.array = array;
        return this;
    }

    /**
     * Gets the value of the partition property.
     * 
     * @return
     *     possible object is
     *     {@link Partition }
     *     
     */
    public Partition getPartition() {
        return partition;
    }

    /**
     * Sets the value of the partition property.
     * 
     * @param partition
     *     allowed object is
     *     {@link Partition }
     *     
     */
    public Cluster setPartition(Partition partition) {
        this.partition = partition;
        return this;
    }

    /**
     * Gets the value of the covariances property.
     * 
     * @return
     *     possible object is
     *     {@link Covariances }
     *     
     */
    public Covariances getCovariances() {
        return covariances;
    }

    /**
     * Sets the value of the covariances property.
     * 
     * @param covariances
     *     allowed object is
     *     {@link Covariances }
     *     
     */
    public Cluster setCovariances(Covariances covariances) {
        this.covariances = covariances;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Cluster addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getKohonenMap(), getArray(), getPartition(), getCovariances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
