/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "linearNorms"})
@XmlRootElement(name="NormContinuous", namespace="http://www.dmg.org/PMML-4_3")
public class NormContinuous
extends Expression
implements HasExtensions {
    @XmlAttribute(name="mapMissingTo")
    @Added(value=Version.PMML_3_2)
    private Double mapMissingTo;
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name="outliers")
    @Added(value=Version.PMML_3_2)
    private OutlierTreatmentMethod outliers;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name="LinearNorm", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private List<LinearNorm> linearNorms;

    public NormContinuous() {
    }

    public NormContinuous(FieldName field, List<LinearNorm> linearNorms) {
        this.field = field;
        this.linearNorms = linearNorms;
    }

    public Double getMapMissingTo() {
        return this.mapMissingTo;
    }

    public NormContinuous setMapMissingTo(Double mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    public FieldName getField() {
        return this.field;
    }

    public NormContinuous setField(FieldName field) {
        this.field = field;
        return this;
    }

    public OutlierTreatmentMethod getOutliers() {
        if (this.outliers == null) {
            return OutlierTreatmentMethod.AS_IS;
        }
        return this.outliers;
    }

    public NormContinuous setOutliers(OutlierTreatmentMethod outliers) {
        this.outliers = outliers;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<LinearNorm> getLinearNorms() {
        if (this.linearNorms == null) {
            this.linearNorms = new ArrayList<LinearNorm>();
        }
        return this.linearNorms;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public NormContinuous addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasLinearNorms() {
        return this.linearNorms != null && this.linearNorms.size() > 0;
    }

    public NormContinuous addLinearNorms(LinearNorm ... linearNorms) {
        this.getLinearNorms().addAll(Arrays.asList(linearNorms));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasLinearNorms()) {
                status = PMMLObject.traverse(visitor, this.getLinearNorms());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

