/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.scorecard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.scorecard.Characteristics;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "characteristics", "modelVerification"})
@XmlRootElement(name="Scorecard", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_1)
public class Scorecard
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="initialScore")
    private Double initialScore;
    @XmlAttribute(name="useReasonCodes")
    private Boolean useReasonCodes;
    @XmlAttribute(name="reasonCodeAlgorithm")
    private ReasonCodeAlgorithm reasonCodeAlgorithm;
    @XmlAttribute(name="baselineScore")
    private Double baselineScore;
    @XmlAttribute(name="baselineMethod")
    private BaselineMethod baselineMethod;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_3")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name="Characteristics", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private Characteristics characteristics;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private static final Double DEFAULT_INITIAL_SCORE = 0.0;
    private static final Boolean DEFAULT_USE_REASON_CODES = true;
    private static final Boolean DEFAULT_SCORABLE = true;

    public Scorecard() {
    }

    public Scorecard(MiningFunction miningFunction, MiningSchema miningSchema, Characteristics characteristics) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.characteristics = characteristics;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public Scorecard setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public Scorecard setMiningFunction(MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public Scorecard setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Double getInitialScore() {
        if (this.initialScore == null) {
            return DEFAULT_INITIAL_SCORE;
        }
        return this.initialScore;
    }

    public Scorecard setInitialScore(Double initialScore) {
        this.initialScore = initialScore;
        return this;
    }

    public boolean isUseReasonCodes() {
        if (this.useReasonCodes == null) {
            return DEFAULT_USE_REASON_CODES;
        }
        return this.useReasonCodes;
    }

    public Scorecard setUseReasonCodes(Boolean useReasonCodes) {
        this.useReasonCodes = useReasonCodes;
        return this;
    }

    public ReasonCodeAlgorithm getReasonCodeAlgorithm() {
        if (this.reasonCodeAlgorithm == null) {
            return ReasonCodeAlgorithm.POINTS_BELOW;
        }
        return this.reasonCodeAlgorithm;
    }

    public Scorecard setReasonCodeAlgorithm(ReasonCodeAlgorithm reasonCodeAlgorithm) {
        this.reasonCodeAlgorithm = reasonCodeAlgorithm;
        return this;
    }

    public Double getBaselineScore() {
        return this.baselineScore;
    }

    public Scorecard setBaselineScore(Double baselineScore) {
        this.baselineScore = baselineScore;
        return this;
    }

    public BaselineMethod getBaselineMethod() {
        if (this.baselineMethod == null) {
            return BaselineMethod.OTHER;
        }
        return this.baselineMethod;
    }

    public Scorecard setBaselineMethod(BaselineMethod baselineMethod) {
        this.baselineMethod = baselineMethod;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public Scorecard setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public Scorecard setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public Scorecard setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public Scorecard setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public Scorecard setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public Scorecard setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public Scorecard setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Characteristics getCharacteristics() {
        return this.characteristics;
    }

    public Scorecard setCharacteristics(Characteristics characteristics) {
        this.characteristics = characteristics;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public Scorecard setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public Scorecard addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getCharacteristics(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ReasonCodeAlgorithm {
        POINTS_ABOVE("pointsAbove"),
        POINTS_BELOW("pointsBelow");

        private final String value;

        private ReasonCodeAlgorithm(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ReasonCodeAlgorithm fromValue(String v) {
            for (ReasonCodeAlgorithm c : ReasonCodeAlgorithm.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum BaselineMethod {
        MAX("max"),
        MIN("min"),
        MEAN("mean"),
        NEUTRAL("neutral"),
        OTHER("other");

        private final String value;

        private BaselineMethod(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static BaselineMethod fromValue(String v) {
            for (BaselineMethod c : BaselineMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

