/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.time_series.ARIMA;
import org.dmg.pmml.time_series.ExponentialSmoothing;
import org.dmg.pmml.time_series.SeasonalTrendDecomposition;
import org.dmg.pmml.time_series.SpectralAnalysis;
import org.dmg.pmml.time_series.TimeSeries;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "localTransformations", "timeSeries", "spectralAnalysis", "arima", "exponentialSmoothing", "seasonalTrendDecomposition", "modelVerification"})
@XmlRootElement(name="TimeSeriesModel", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_0)
public class TimeSeriesModel
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="bestFit", required=true)
    private Algorithm bestFit;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_1)
    private ModelExplanation modelExplanation;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name="TimeSeries", namespace="http://www.dmg.org/PMML-4_3")
    private List<TimeSeries> timeSeries;
    @XmlElement(name="SpectralAnalysis", namespace="http://www.dmg.org/PMML-4_3")
    private SpectralAnalysis spectralAnalysis;
    @XmlElement(name="ARIMA", namespace="http://www.dmg.org/PMML-4_3")
    private ARIMA arima;
    @XmlElement(name="ExponentialSmoothing", namespace="http://www.dmg.org/PMML-4_3")
    private ExponentialSmoothing exponentialSmoothing;
    @XmlElement(name="SeasonalTrendDecomposition", namespace="http://www.dmg.org/PMML-4_3")
    private SeasonalTrendDecomposition seasonalTrendDecomposition;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;

    public TimeSeriesModel() {
    }

    public TimeSeriesModel(MiningFunction miningFunction, Algorithm bestFit, MiningSchema miningSchema) {
        this.miningFunction = miningFunction;
        this.bestFit = bestFit;
        this.miningSchema = miningSchema;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public TimeSeriesModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public TimeSeriesModel setMiningFunction(MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public TimeSeriesModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Algorithm getBestFit() {
        return this.bestFit;
    }

    public TimeSeriesModel setBestFit(Algorithm bestFit) {
        this.bestFit = bestFit;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public TimeSeriesModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public TimeSeriesModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public TimeSeriesModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public TimeSeriesModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public TimeSeriesModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public TimeSeriesModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public List<TimeSeries> getTimeSeries() {
        if (this.timeSeries == null) {
            this.timeSeries = new ArrayList<TimeSeries>();
        }
        return this.timeSeries;
    }

    public SpectralAnalysis getSpectralAnalysis() {
        return this.spectralAnalysis;
    }

    public TimeSeriesModel setSpectralAnalysis(SpectralAnalysis spectralAnalysis) {
        this.spectralAnalysis = spectralAnalysis;
        return this;
    }

    public ARIMA getARIMA() {
        return this.arima;
    }

    public TimeSeriesModel setARIMA(ARIMA arima) {
        this.arima = arima;
        return this;
    }

    public ExponentialSmoothing getExponentialSmoothing() {
        return this.exponentialSmoothing;
    }

    public TimeSeriesModel setExponentialSmoothing(ExponentialSmoothing exponentialSmoothing) {
        this.exponentialSmoothing = exponentialSmoothing;
        return this;
    }

    public SeasonalTrendDecomposition getSeasonalTrendDecomposition() {
        return this.seasonalTrendDecomposition;
    }

    public TimeSeriesModel setSeasonalTrendDecomposition(SeasonalTrendDecomposition seasonalTrendDecomposition) {
        this.seasonalTrendDecomposition = seasonalTrendDecomposition;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public TimeSeriesModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public TimeSeriesModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTimeSeries() {
        return this.timeSeries != null && this.timeSeries.size() > 0;
    }

    public TimeSeriesModel addTimeSeries(TimeSeries ... timeSeries) {
        this.getTimeSeries().addAll(Arrays.asList(timeSeries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getLocalTransformations());
            }
            if (status == VisitorAction.CONTINUE && this.hasTimeSeries()) {
                status = PMMLObject.traverse(visitor, this.getTimeSeries());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getSpectralAnalysis(), this.getARIMA(), this.getExponentialSmoothing(), this.getSeasonalTrendDecomposition(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    @Added(value=Version.PMML_4_0)
    public static enum Algorithm {
        ARIMA("ARIMA"),
        EXPONENTIAL_SMOOTHING("ExponentialSmoothing"),
        SEASONAL_TREND_DECOMPOSITION("SeasonalTrendDecomposition"),
        SPECTRAL_ANALYSIS("SpectralAnalysis");

        private final String value;

        private Algorithm(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Algorithm fromValue(String v) {
            for (Algorithm c : Algorithm.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

