/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.Tanimoto;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "measure"})
@XmlRootElement(name="ComparisonMeasure", namespace="http://www.dmg.org/PMML-4_3")
public class ComparisonMeasure
extends PMMLObject
implements HasExtensions<ComparisonMeasure> {
    @XmlAttribute(name="kind", required=true)
    private Kind kind;
    @XmlAttribute(name="compareFunction")
    private CompareFunction compareFunction;
    @XmlAttribute(name="minimum")
    private Double minimum;
    @XmlAttribute(name="maximum")
    private Double maximum;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElements(value={@XmlElement(name="euclidean", namespace="http://www.dmg.org/PMML-4_3", type=Euclidean.class), @XmlElement(name="squaredEuclidean", namespace="http://www.dmg.org/PMML-4_3", type=SquaredEuclidean.class), @XmlElement(name="chebychev", namespace="http://www.dmg.org/PMML-4_3", type=Chebychev.class), @XmlElement(name="cityBlock", namespace="http://www.dmg.org/PMML-4_3", type=CityBlock.class), @XmlElement(name="minkowski", namespace="http://www.dmg.org/PMML-4_3", type=Minkowski.class), @XmlElement(name="simpleMatching", namespace="http://www.dmg.org/PMML-4_3", type=SimpleMatching.class), @XmlElement(name="jaccard", namespace="http://www.dmg.org/PMML-4_3", type=Jaccard.class), @XmlElement(name="tanimoto", namespace="http://www.dmg.org/PMML-4_3", type=Tanimoto.class), @XmlElement(name="binarySimilarity", namespace="http://www.dmg.org/PMML-4_3", type=BinarySimilarity.class)})
    private Measure measure;

    public ComparisonMeasure() {
    }

    public ComparisonMeasure(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public ComparisonMeasure setKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    public CompareFunction getCompareFunction() {
        if (this.compareFunction == null) {
            return CompareFunction.ABS_DIFF;
        }
        return this.compareFunction;
    }

    public ComparisonMeasure setCompareFunction(CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public ComparisonMeasure setMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public ComparisonMeasure setMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public ComparisonMeasure setMeasure(Measure measure) {
        this.measure = measure;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public ComparisonMeasure addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getMeasure());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Kind {
        DISTANCE("distance"),
        SIMILARITY("similarity");

        private final String value;

        private Kind(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Kind fromValue(String v) {
            for (Kind c : Kind.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

