/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.general_regression.BaselineCell;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "baselineCells"})
@XmlRootElement(name="BaselineStratum", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_0)
public class BaselineStratum
extends PMMLObject
implements HasExtensions<BaselineStratum> {
    @XmlAttribute(name="value", required=true)
    private String value;
    @XmlAttribute(name="label")
    private String label;
    @XmlAttribute(name="maxTime", required=true)
    private double maxTime;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name="BaselineCell", namespace="http://www.dmg.org/PMML-4_3")
    private List<BaselineCell> baselineCells;

    public BaselineStratum() {
    }

    public BaselineStratum(String value, double maxTime) {
        this.value = value;
        this.maxTime = maxTime;
    }

    public String getValue() {
        return this.value;
    }

    public BaselineStratum setValue(String value) {
        this.value = value;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public BaselineStratum setLabel(String label) {
        this.label = label;
        return this;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public BaselineStratum setMaxTime(double maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<BaselineCell> getBaselineCells() {
        if (this.baselineCells == null) {
            this.baselineCells = new ArrayList<BaselineCell>();
        }
        return this.baselineCells;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public BaselineStratum addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBaselineCells() {
        return this.baselineCells != null && this.baselineCells.size() > 0;
    }

    public BaselineStratum addBaselineCells(BaselineCell ... baselineCells) {
        this.getBaselineCells().addAll(Arrays.asList(baselineCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasBaselineCells()) {
                status = PMMLObject.traverse(visitor, this.getBaselineCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

